/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * "$Id:"
 */

#ifndef TVMET_VECTOR_OPERATORS_H
#define TVMET_VECTOR_OPERATORS_H

/* forwards */
#ifdef TVMET_HAVE_COMPLEX
template<class T> class std::complex;
#endif

namespace tvmet {

/**
 * \fn operator<<(std::ostream& os, const Vector<T, Sz>& rhs)
 * \brief Overload operator for i/o
 * \ingroup _binary_operator
 */
template<class T, std::size_t Sz>
inline
std::ostream& operator<<(std::ostream& os, const Vector<T, Sz>& rhs) {
  return rhs.print_on(os);
}

/***********************************************************************
 * global binary math, bitops and logical
 * documented by doc/operators_doc.cc
 ***********************************************************************/

/*
 * Vector<T1, Sz> and Vector<T2, Sz>
 */
#define TVMET_BINARY_OPERATOR(FUNCTIONAL, OP)                   	\
template<class T1, class T2, std::size_t Sz> 	                  	\
inline                 			      			      	\
XprVector<                   						\
  XprBinOp<                   						\
    FUNCTIONAL<T1, T2>,                   				\
    VectorConstReference<T1, Sz>,              				\
    VectorConstReference<T2, Sz>               				\
  >,									\
  Sz									\
>                   			              			\
operator OP (const Vector<T1, Sz>& lhs, const Vector<T2, Sz>& rhs) { 	\
  typedef XprBinOp <                    				\
    FUNCTIONAL<T1, T2>,  	                 			\
    VectorConstReference<T1, Sz>,              				\
    VectorConstReference<T2, Sz>                     	      		\
  >							expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(lhs.cref(), rhs.cref()));	\
}

TVMET_BINARY_OPERATOR(fcnl_Add, +)
TVMET_BINARY_OPERATOR(fcnl_Sub, -)
TVMET_BINARY_OPERATOR(fcnl_Mul, *)
TVMET_BINARY_OPERATOR(fcnl_Div, /)
TVMET_BINARY_OPERATOR(fcnl_Mod, %)
TVMET_BINARY_OPERATOR(fcnl_BitwiseXor, ^)
TVMET_BINARY_OPERATOR(fcnl_BitwiseAnd, &)
TVMET_BINARY_OPERATOR(fcnl_BitwiseOr, |)
TVMET_BINARY_OPERATOR(fcnl_Shl, <<)
TVMET_BINARY_OPERATOR(fcnl_Shr, >>)
TVMET_BINARY_OPERATOR(fcnl_Greater, >)
TVMET_BINARY_OPERATOR(fcnl_Less, <)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||)
#undef TVMET_BINARY_OPERATOR

/*
 * Vector<T, Sz> and POD's
 */
#define TVMET_BINARY_OPERATOR(FUNCTIONAL, OP, TP)               	\
template<class T, std::size_t Sz>              				\
inline                 			      			      	\
XprVector<             							\
  XprBinOp<          							\
    FUNCTIONAL< T, TP >,          					\
    VectorConstReference<T, Sz>,       					\
    XprLiteral< TP >          						\
  >,          								\
  Sz									\
>          								\
operator OP (const Vector<T, Sz>& lhs, TP rhs) {			\
  typedef XprBinOp<          						\
    FUNCTIONAL<T, TP >,          					\
    VectorConstReference<T, Sz>,       					\
    XprLiteral< TP >          						\
  >							expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(lhs.cref(), XprLiteral< TP >(rhs))); \
}          								\
          								\
template<class T, std::size_t Sz>     					\
inline                 			      			      	\
XprVector<  								\
  XprBinOp<          							\
    FUNCTIONAL< TP, T>,          					\
    XprLiteral< TP >,          						\
    VectorConstReference<T, Sz>       					\
  >,          								\
  Sz									\
>          								\
operator OP (TP lhs, const Vector<T, Sz>& rhs) {         		\
  typedef XprBinOp<         						\
    FUNCTIONAL< TP, T>,         					\
    XprLiteral< TP >,         						\
    VectorConstReference<T, Sz>       					\
  >							expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(XprLiteral< TP >(lhs), rhs.cref())); \
}

TVMET_BINARY_OPERATOR(fcnl_Add, +, int)
TVMET_BINARY_OPERATOR(fcnl_Sub, -, int)
TVMET_BINARY_OPERATOR(fcnl_Mul, *, int)
TVMET_BINARY_OPERATOR(fcnl_Div, /, int)
TVMET_BINARY_OPERATOR(fcnl_Mod, %, int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseXor, ^, int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseAnd, &, int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseOr, |, int)
TVMET_BINARY_OPERATOR(fcnl_Shl, <<, int)
TVMET_BINARY_OPERATOR(fcnl_Shr, >>, int)
TVMET_BINARY_OPERATOR(fcnl_Greater, >, int)
TVMET_BINARY_OPERATOR(fcnl_Less, <, int)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=, int)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=, int)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==, int)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=, int)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&, int)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||, int)

#ifdef TVMET_HAVE_LONG_LONG
TVMET_BINARY_OPERATOR(fcnl_Add, +, long long int)
TVMET_BINARY_OPERATOR(fcnl_Sub, -, long long int)
TVMET_BINARY_OPERATOR(fcnl_Mul, *, long long int)
TVMET_BINARY_OPERATOR(fcnl_Div, /, long long int)
TVMET_BINARY_OPERATOR(fcnl_Mod, %, long long int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseXor, ^, long long int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseAnd, &, long long int)
TVMET_BINARY_OPERATOR(fcnl_BitwiseOr, |, long long int)
TVMET_BINARY_OPERATOR(fcnl_Shl, <<, long long int)
TVMET_BINARY_OPERATOR(fcnl_Shr, >>, long long int)
TVMET_BINARY_OPERATOR(fcnl_Greater, >, long long int)
TVMET_BINARY_OPERATOR(fcnl_Less, <, long long int)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=, long long int)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=, long long int)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==, long long int)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=, long long int)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&, long long int)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||, long long int)
#endif // TVMET_HAVE_LONG_LONG

TVMET_BINARY_OPERATOR(fcnl_Add, +, float)
TVMET_BINARY_OPERATOR(fcnl_Sub, -, float)
TVMET_BINARY_OPERATOR(fcnl_Mul, *, float)
TVMET_BINARY_OPERATOR(fcnl_Div, /, float)
TVMET_BINARY_OPERATOR(fcnl_Greater, >, float)
TVMET_BINARY_OPERATOR(fcnl_Less, <, float)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=, float)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=, float)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==, float)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=, float)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&, float)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||, float)

TVMET_BINARY_OPERATOR(fcnl_Add, +, double)
TVMET_BINARY_OPERATOR(fcnl_Sub, -, double)
TVMET_BINARY_OPERATOR(fcnl_Mul, *, double)
TVMET_BINARY_OPERATOR(fcnl_Div, /, double)
TVMET_BINARY_OPERATOR(fcnl_Greater, >, double)
TVMET_BINARY_OPERATOR(fcnl_Less, <, double)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=, double)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=, double)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==, double)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=, double)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&, double)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||, double)

#ifdef TVMET_HAVE_LONG_DOUBLE
TVMET_BINARY_OPERATOR(fcnl_Add, +, long double)
TVMET_BINARY_OPERATOR(fcnl_Sub, -, long double)
TVMET_BINARY_OPERATOR(fcnl_Mul, *, long double)
TVMET_BINARY_OPERATOR(fcnl_Div, /, long double)
TVMET_BINARY_OPERATOR(fcnl_Greater, >, long double)
TVMET_BINARY_OPERATOR(fcnl_Less, <, long double)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=, long double)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=, long double)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==, long double)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=, long double)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&, long double)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||, long double)
#endif // TVMET_HAVE_LONG_DOUBLE

#undef TVMET_BINARY_OPERATOR

#ifdef TVMET_HAVE_COMPLEX

/*
 * Vector<std::complex<T>, Sz> and std::complex<T>
 * std::complex<T> and Vector<std::complex<T>, Sz>
 * \todo type promotion
 */
#define TVMET_BINARY_OPERATOR(FUNCTIONAL, OP)		               	\
template<class T, std::size_t Sz>              				\
inline                 			      			      	\
XprVector<             							\
  XprBinOp<          							\
    FUNCTIONAL< std::complex<T>, std::complex<T> >,			\
    VectorConstReference< std::complex<T>, Sz>,				\
    XprLiteral< std::complex<T> >          				\
  >,          								\
  Sz									\
>          								\
operator OP (const Vector<std::complex<T>, Sz>& lhs, const std::complex<T>& rhs) { \
  typedef XprBinOp<          						\
    FUNCTIONAL< std::complex<T>, std::complex<T> >,			\
    VectorConstReference< std::complex<T>, Sz>,				\
    XprLiteral< std::complex<T> >          				\
  >							expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(lhs.cref(), XprLiteral< std::complex<T> >(rhs))); \
}          								\
          								\
template<class T, std::size_t Sz>     					\
inline                 			      			      	\
XprVector<  								\
  XprBinOp<          							\
    FUNCTIONAL< std::complex<T>, std::complex<T> >,			\
    XprLiteral< std::complex<T> >,          				\
    VectorConstReference< std::complex<T>, Sz>				\
  >,          								\
  Sz									\
>          								\
operator OP (const std::complex<T>& lhs, const Vector< std::complex<T>, Sz>& rhs) { 	\
  typedef XprBinOp<         						\
    FUNCTIONAL< std::complex<T>, std::complex<T> >,			\
    XprLiteral< std::complex<T> >,         				\
    VectorConstReference< std::complex<T>, Sz>				\
  >							expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(XprLiteral< std::complex<T> >(lhs), rhs.cref())); \
}

TVMET_BINARY_OPERATOR(fcnl_Add, +)
TVMET_BINARY_OPERATOR(fcnl_Sub, -)
TVMET_BINARY_OPERATOR(fcnl_Mul, *)
TVMET_BINARY_OPERATOR(fcnl_Div, /)
TVMET_BINARY_OPERATOR(fcnl_Mod, %)
TVMET_BINARY_OPERATOR(fcnl_BitwiseXor, ^)
TVMET_BINARY_OPERATOR(fcnl_BitwiseAnd, &)
TVMET_BINARY_OPERATOR(fcnl_BitwiseOr, |)
TVMET_BINARY_OPERATOR(fcnl_Shl, <<)
TVMET_BINARY_OPERATOR(fcnl_Shr, >>)
TVMET_BINARY_OPERATOR(fcnl_Greater, >)
TVMET_BINARY_OPERATOR(fcnl_Less, <)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||)
#undef TVMET_BINARY_OPERATOR

#endif // TVMET_HAVE_COMPLEX

/*
 * XprVector<E, Sz> and Vector<T, Sz>
 */
#define TVMET_BINARY_OPERATOR(FUNCTIONAL, OP)                   	\
template<class E, class T, std::size_t Sz>             			\
inline                 			      			      	\
XprVector<                    	      					\
  XprBinOp<                     	      				\
    FUNCTIONAL<typename E::value_type, T>,                    	      	\
    XprVector<E, Sz>,                  	      				\
    VectorConstReference<T, Sz>                	      			\
  >,                     	      					\
  Sz									\
>                      	      						\
operator OP (XprVector<E, Sz> lhs, const Vector<T, Sz>& rhs) {		\
  typedef XprBinOp<                     	      			\
    FUNCTIONAL<typename E::value_type, T>,                    	      	\
    XprVector<E, Sz>,                  	      				\
    VectorConstReference<T, Sz>                	      			\
  > 							 expr_type; 	\
  return XprVector<expr_type, Sz>(expr_type(lhs, rhs.cref()));		\
}                    	      						\
                    	      						\
template<class E, class T, std::size_t Sz>             			\
inline                 			      			      	\
XprVector<                    	      					\
  XprBinOp<                     	      				\
    FUNCTIONAL<T, typename E::value_type>,                    	      	\
    VectorConstReference<T, Sz>,               	      			\
    XprVector<E, Sz>                   	      				\
  >,                     	      					\
  Sz									\
>                      	      						\
operator OP (const Vector<T, Sz>& lhs, XprVector<E, Sz> rhs) {         	\
  typedef XprBinOp<                     	      			\
    FUNCTIONAL<T, typename E::value_type>,                    	      	\
    VectorConstReference<T, Sz>,      	      				\
    XprVector<E, Sz>                  	      				\
  > 						 	expr_type; 	\
  return XprVector<expr_type, Sz>(expr_type(lhs.cref(), rhs));         	\
}

TVMET_BINARY_OPERATOR(fcnl_Add, +)
TVMET_BINARY_OPERATOR(fcnl_Sub, -)
TVMET_BINARY_OPERATOR(fcnl_Mul, *)
TVMET_BINARY_OPERATOR(fcnl_Div, /)
TVMET_BINARY_OPERATOR(fcnl_Mod, %)
TVMET_BINARY_OPERATOR(fcnl_BitwiseXor, ^)
TVMET_BINARY_OPERATOR(fcnl_BitwiseAnd, &)
TVMET_BINARY_OPERATOR(fcnl_BitwiseOr, |)
TVMET_BINARY_OPERATOR(fcnl_Shl, <<)
TVMET_BINARY_OPERATOR(fcnl_Shr, >>)
TVMET_BINARY_OPERATOR(fcnl_Greater, >)
TVMET_BINARY_OPERATOR(fcnl_Less, <)
TVMET_BINARY_OPERATOR(fcnl_GreaterOrEqual, >=)
TVMET_BINARY_OPERATOR(fcnl_LessOrEqual, <=)
TVMET_BINARY_OPERATOR(fcnl_Equal, ==)
TVMET_BINARY_OPERATOR(fcnl_NotEqual, !=)
TVMET_BINARY_OPERATOR(fcnl_LogicalAnd, &&)
TVMET_BINARY_OPERATOR(fcnl_LogicalOr, ||)
#undef TVMET_BINARY_OPERATOR

/***********************************************************************
 * global unary operators
 * documented by doc/operators_doc.cc
 ***********************************************************************/

/*
 * Operators on Vector<T, Sz>
 */
#define TVMET_UNARY_OPERATOR(FUNCTIONAL, OP)                   		\
template <class T, std::size_t Sz>                                      \
inline                                                        		\
XprVector<                                                    		\
  XprUnOp<                                                        	\
    FUNCTIONAL<T>,                                                      \
    VectorConstReference<T, Sz>                                       	\
  >,                                                        		\
  Sz									\
>                                                        		\
operator OP (const Vector<T, Sz>& rhs) {                                \
  typedef XprUnOp<                                                      \
    FUNCTIONAL<T>,                                                      \
    VectorConstReference<T, Sz>                                        	\
  >  							 expr_type;	\
  return XprVector<expr_type, Sz>(expr_type(rhs.cref()));              	\
}

TVMET_UNARY_OPERATOR(fcnl_LogicalNot, !)
TVMET_UNARY_OPERATOR(fcnl_BitwiseNot, ~)
TVMET_UNARY_OPERATOR(fcnl_Negate, -)
#undef TVMET_UNARY_OPERATOR

} // namespace tvmet

#endif // TVMET_VECTOR_OPERATORS_H

// Local Variables:
// mode:C++
// End:
