/*
 * Tiny Vector Matrix Library
 * Dense Vector Matrix Libary of Tiny size using Expression Templates
 *
 * Copyright (C) 2001, 2002 Olaf Petzold <opetzold@wit.regiocom.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * "$Id:"
 */

#ifndef TVMET_H
#define TVMET_H

#include <tvmet/config.h>

/*
 * Compiler specifics
 */
#if defined(__GNUC__)
#  include <tvmet/config/config-gcc.h>
#endif

#if defined(__ICC)
#  include <tvmet/config/config-icc.h>
#endif

#if defined(__KCC)
#  include <tvmet/config/config-kcc.h>
#endif

#if defined(__PGI)
#  include <tvmet/config/config-pgi.h>
#endif


/*
 * give up for these cases
 */
#if !defined(TVMET_HAVE_MUTABLE)
#  error "Your compiler doesn't support the mutable keyword! Giving up."
#endif

#if !defined(TVMET_HAVE_TYPENAME)
#  error "Your compiler doesn't support the typename keyword! Giving up."
#endif

#if !defined(TVMET_HAVE_NAMESPACES)
#  error "Your compiler doesn't support the namespace concept! Giving up."
#endif

#if !defined(TVMET_HAVE_PARTIAL_SPECIALIZATION)
#  error "Your compiler doesn't support partial specialization! Giving up."
#endif


/*
 * other specials
 */
#if defined(TVMET_HAVE_IEEE_MATH)
#  define _ALL_SOURCE
#  if !defined(_XOPEN_SOURCE)
#    define _XOPEN_SOURCE
#  endif
#  if !defined(_XOPEN_SOURCE_EXTENDED)
#    define _XOPEN_SOURCE_EXTENDED
#  endif
#endif

/*
 * debug mode
 */

/**
 * \def TVMET_DEBUG
 * This is defined if <code>DEBUG</code> is defined. This enables runtime error
 * bounds checking.
 */


/*
 * other
 */
#include <tvmet/TvmetBase.h>

#endif // TVMET_H

// Local Variables:
// mode:C++
// End:
