#!/usr/local/bin/perl
# index.cgi
# Display mail forwarding from .forward file

require './forward-lib.pl';
&header($text{'index_title'}, "", undef, 0, 1);
print "<hr>\n";

print "<br>$text{'index_desc'}<p>\n";

if ($config{'mail_system'} == 0) {
	# Sendmail forwarding
	@aliases = &list_aliases();
	if (@aliases) {
		# find a good place to split
		$lines = 0;
		for($i=0; $i<@aliases; $i++) {
			$aline[$i] = $lines;
			$al = scalar(@{$aliases[$i]->{'values'}});
			$lines += ($al ? $al : 1);
			}
		$midline = int(($lines+1) / 2);
		for($mid=0; $mid<@aliases && $aline[$mid] < $midline; $mid++) { }

		# render tables
		print "<table width=100%> <tr><td width=50% valign=top>\n";
		&aliases_table(@aliases[0..$mid-1]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @aliases) { &aliases_table(@aliases[$mid..$#aliases]); }
		print "</td></tr> </table>\n";
		}
	else {
		print "<b>$text{'index_none'}</b> <p>\n";
		}
	}
else {
	# Qmail forwarding
	@aliases = &list_dotqmails();
	if (@aliases) {
		# find a good place to split
		$lines = 0;
		for($i=0; $i<@aliases; $i++) {
			$aline[$i] = $lines;
			$al = scalar(@{$aliases[$i]->{'values'}});
			$lines += ($al ? $al : 1);
			}
		$midline = int(($lines+1) / 2);
		for($mid=0; $mid<@aliases && $aline[$mid] < $midline; $mid++) { }

		# render tables
		print "<table width=100%> <tr><td width=50% valign=top>\n";
		&dotqmail_table(@aliases[0..$mid-1]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @aliases) { &dotqmail_table(@aliases[$mid..$#aliases]); }
		print "</td></tr> </table>\n";
		}
	else {
		print "<b>$text{'index_none'}</b> <p>\n";
		}
	}
print "<a href='edit_alias.cgi?new=1'>$text{'index_add'}</a>\n";
print "&nbsp;&nbsp;&nbsp;<a href='edit_forward.cgi'>",&text('index_edit',
	"<tt>.forward</tt>"),"</a>\n" if ($config{'mail_system'} == 0);
print "<p>\n";

print "<hr>\n";
&footer("/", $text{'index'});

sub aliases_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'aliases_to'}</b></td> <td><b>$text{'aliases_enabled'}</b></td> </tr>\n";
foreach $a (@_) {
	print "<tr $cb>\n";
	print "<td><a href=\"edit_alias.cgi?num=$a->{'num'}\">";
	foreach $v (@{$a->{'values'}}) {
		($anum, $astr) = &alias_type($v);
		print &text("aliases_type$anum", "<tt>$astr</tt>"),"<br>\n";
		}
	print "</td>\n";
	printf "<td>%s</td>\n", $a->{'enabled'} ? $text{'yes'} :
		"<font color=#ff0000>$text{'no'}</font>";
	print "</tr>\n";
	}
print "</table>\n";
}

sub dotqmail_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'aliases_from'}</b></td> <td><b>$text{'aliases_to'}</b></td> </tr>\n";
foreach $a (@_) {
	print "<tr $cb>\n";
	print "<td><a href=\"edit_alias.cgi?file=$a->{'file'}\">",
	      $a->{'name'} ? "$remote_user-$a->{'name'}" : $remote_user,
	      "</td> <td>\n";
	foreach $v (@{$a->{'values'}}) {
		($anum, $astr) = &alias_type($v);
		print &text("aliases_type$anum", "<tt>$astr</tt>"),"<br>\n";
		}
	print "</td> </tr>\n";
	}
print "</table>\n";

}

