#!/usr/local/bin/perl
# list_keys.cgi
# Display all keys in your keyring

require './gnupg-lib.pl';
&header($text{'keys_title'}, "");
print "<hr>\n";

@keys = &list_keys();
print "$text{'keys_desc'}<p>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'keys_id'}</b></td> ",
      "<td><b>$text{'keys_secret'}</b></td> <td><b>$text{'keys_date'}</b></td> ",
      "<td><b>$text{'keys_name'}</b></td> <td><b>$text{'keys_email'}</b></td> ",
      "</tr>\n";
foreach $k (@keys) {
	print "<tr $cb>\n";
	print "<td><a href='edit_key.cgi?idx=$k->{'index'}'>$k->{'key'}</a></td>\n";
	print "<td>",$k->{'secret'} ? $text{'yes'} : $text{'no'},"</td>\n";
	print "<td>$k->{'date'}</td>\n";
	print "<td>",join("<br>", map { &html_escape($_) } @{$k->{'name'}}),"&nbsp;</td>\n";
	print "<td>",join("<br>", map { &html_escape($_) } @{$k->{'email'}}),"&nbsp;</td>\n";
	print "</tr>\n";
	}
print "</table><br>\n";

print "<hr>\n";
print "$text{'keys_importdesc'}<p>\n";
print "<form action=import.cgi method=post enctype=multipart/form-data>\n";
print "<input type=submit value='$text{'keys_import'}'>\n";
print "<input type=file name=key></form>\n";

print "<hr>\n";
print &text('keys_recvdesc', "<tt>$config{'keyserver'}</tt>"),"<p>\n";
print "<form action=recv.cgi>\n";
print "<input type=submit value='$text{'keys_recv'}'>\n";
print "<input name=id size=10></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

