#!/usr/local/bin/perl
# inbox_login.cgi
# Save inbox POP3 login and password

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$folder = $folders[$in{'folder'}];

# Validate inputs
&error_setup($text{'mail_loginerr'});
$in{'user'} =~ /\S/ || &error($text{'save_euser'});
$folder->{'user'} = $pop3{'user'} = $in{'user'};
$folder->{'pass'} = $pop3{'pass'} = $in{'pass'};
@err = &pop3_login($folder);
if ($err[0] == 0) {
	&error($err[1]);
	}
elsif ($err[0] == 2) {
	&error(&text('save_elogin', $err[1]));
	}
else {
	&pop3_logout($err[1]);
	}

# Save inbox .pop3 file
&write_file("$user_module_config_directory/inbox.pop3", \%pop3);
&redirect("");

