#!/usr/local/bin/perl
# list_folders.cgi
# Display a list of all folders and allows additional and deletion

require './mailbox-lib.pl';
&header($text{'folders_title'}, "");
print "<hr>\n";

@folders = &list_folders();
print &text('folders_desc', $folders_dir),"<p>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'folders_name'}</b></td> ",
      "<td><b>$text{'folders_path'}</b></td> ",
      "<td><b>$text{'folders_type'}</b></td> ",
      "<td><b>$text{'folders_size'}</b></td> </tr>\n";
foreach $f (@folders) {
	print "<tr $cb>\n";
	if ($f->{'inbox'} || $f->{'drafts'}) {
		print "<td>$f->{'name'}</td>\n";
		}
	elsif ($f->{'type'} == 2) {
		print "<td><a href='edit_pop3.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	else {
		print "<td><a href='edit_folder.cgi?idx=$f->{'index'}'>",
		      "$f->{'name'}</a></td>\n";
		}
	if ($f->{'type'} == 2) {
		print "<td>",&text('folders_serv', "<tt>$f->{'user'}</tt>",
				   "<tt>$f->{'server'}</tt>"),"</td>\n";
		print "<td>POP3</td>\n";
		print "<td><br></td>\n";
		}
	else {
		local $mf = &folder_file($f);
		print "<td>$mf</td>\n";
		print "<td>",$f->{'type'} == 1 ? $text{'folders_maildir'} :
			     $f->{'type'} == 3 ? $text{'folders_mhdir'} :
				      $text{'folders_mbox'},"</td>\n";
		if (-d $mf) {
			local $sz = &disk_usage_kb($mf);
			print "<td>$sz kB</td>\n";
			}
		else {
			local @st = stat($mf);
			print "<td>",int($st[7]/1024)," kB</td>\n";
			}
		}
	print "</tr>\n";
	}
print "</table>\n";
print "<a href='edit_folder.cgi?new=1&mode=0'>$text{'folders_create'}</a>\n";
print "&nbsp;" x 3;
print "<a href='edit_folder.cgi?new=1&mode=1'>$text{'folders_add'}</a>\n";
print "&nbsp;" x 3;
print "<a href='edit_pop3.cgi?new=1'>$text{'folders_padd'}</a><br>\n";

print "<hr>\n";
&footer("", $text{'index'});

