#!/usr/local/bin/perl
# save_pop3.cgi
# Create, modify or delete a POP3 folder

require './mailbox-lib.pl';
&ReadParse();
@folders = &list_folders();
$folder = $folders[$in{'idx'}] if (!$in{'new'});
&error_setup($text{'save_err'});

if ($in{'delete'}) {
	# Just delete this folder and cache
	unlink("$user_module_config_directory/$folder->{'id'}.pop3");
	system("rm -rf $user_module_config_directory/$folder->{'id'}.cache");
	}
else {
	# Validate inputs
	$in{'name'} =~ /\S/ || &error($text{'save_ename'});
	gethostbyname($in{'server'}) || &check_ipaddress($in{'server'}) ||
		&error($text{'save_eserver'});
	$in{'user'} =~ /\S/ || &error($text{'save_euser'});

	# Save the folder
	$pop3{'id'} = $folder->{'id'} || time();
	$pop3{'name'} = $in{'name'};
	$pop3{'server'} = $in{'server'};
	$pop3{'user'} = $in{'user'};
	$pop3{'pass'} = $in{'pass'};
	local @err = &pop3_login(\%pop3);
	if ($err[0] == 0) {
		&error($err[1]);
		}
	elsif ($err[0] == 2) {
		&error(&text('save_elogin', $err[1]));
		}
	else {
		&pop3_logout($err[1]);
		}
	&write_file("$user_module_config_directory/$pop3{'id'}.pop3", \%pop3);
	}
&redirect("list_folders.cgi");

