#!/usr/local/bin/perl
# view_mail.cgi
# View a single email message 

require './mailbox-lib.pl';

$force_charset = '';
&ReadParse();
foreach $a (&list_addresses()) {
	$inbook{$a->[0]}++;
	}

$module_index_link = "/$module_name/index.cgi?folder=$in{'folder'}";
&header($text{'view_title'}, "");
@folders = &list_folders();
$folder = $folders[$in{'folder'}];
@mail = &mailbox_list_mails($in{'idx'}, $in{'idx'}, $folder);
$mail = $mail[$in{'idx'}];
&notes_decode($mail, $folder);
&parse_mail($mail);
@sub = split(/\0/, $in{'sub'});
$subs = join("", map { "&sub=$_" } @sub);
foreach $s (@sub) {
        # We are looking at a mail within a mail ..
	&decrypt_attachments($mail);
        local $amail = &extract_mail($mail->{'attach'}->[$s]->{'data'});
        &parse_mail($amail);
        $mail = $amail;
        }

dbmopen(%read, "$user_module_config_directory/read", 0600);
if ($userconfig{'auto_mark'}) {
	eval { $read{$mail->{'header'}->{'message-id'}} = 1 }
		if (!$read{$mail->{'header'}->{'message-id'}});
	}

print "<center>\n";
if (!@sub) {
	if ($in{'idx'}) {
		print "<a href='view_mail.cgi?idx=",
		      $in{'idx'}-1,"&folder=$in{'folder'}'>",
		      "<img src=/images/left.gif border=0 ",
		      "align=middle></a>\n";
		}
	print "<font size=+1>",&text('view_desc', $in{'idx'}+1,
			$folder->{'name'}),"</font>\n";
	if ($in{'idx'} < @mail-1) {
		print "<a href='view_mail.cgi?idx=",
		      $in{'idx'}+1,"&folder=$in{'folder'}'>",
		      "<img src=/images/right.gif border=0 ",
		      "align=middle></a>\n";
		}
	}
else {
	print "<font size=+1>$text{'view_sub'}</font>\n";
	}
print "</center>\n";
print "<hr>\n";

print "<form action=reply_mail.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=folder value='$in{'folder'}'>\n";
foreach $s (@sub) {
	print "<input type=hidden name=sub value='$s'>\n";
	}

# Check for encryption
($deccode, $decmessage) = &decrypt_attachments($mail);
@attach = @{$mail->{'attach'}};

# Find body attachment
foreach $a (@attach) {
	if ($a->{'type'} eq 'text/plain' || $a->{'type'} eq 'text') {
		$body = $a;
		last;
		}
	}

# Check for signing
if (&has_command("gpg") && &foreign_check("gnupg")) {
	# Check for GnuPG signatures
	local $sig;
	foreach $a (@attach) {
		$sig = $a if ($a->{'type'} =~ /^application\/pgp-signature/);
		}
	if ($sig) {
		# Verify the signature against the rest of the attachment
		&foreign_require("gnupg", "gnupg-lib.pl");
		local $rest = $sig->{'parent'}->{'attach'}->[0];
		$rest->{'raw'} =~ s/\r//g;
		$rest->{'raw'} =~ s/\n/\r\n/g;
		($sigcode, $sigmessage) = &foreign_call("gnupg",
				"verify_data", $rest->{'raw'}, $sig->{'data'});
		@attach = grep { $_ ne $sig } @attach;
		}
	elsif ($body && $body->{'data'} =~ /(-+BEGIN PGP SIGNED MESSAGE-+\n(Hash:\s+(\S+)\n\n)?([\000-\377]+\n)-+BEGIN PGP SIGNATURE-+\n([\000-\377]+)-+END PGP SIGNATURE-+\n)/i) {
		# Signature is in body text!
		local $sig = $1;
		local $text = $4;
		&foreign_require("gnupg", "gnupg-lib.pl");
		($sigcode, $sigmessage) = &foreign_call("gnupg",
							"verify_data", $sig);
		if ($sigcode == 0 || $sigcode == 1) {
			# XXX what about replying?
			$body->{'data'} = $text;
			}
		}
	}

# Strip out attachments not to display as icons
@attach = grep { $_ ne $body } @attach;
@attach = grep { !$_->{'attach'} } @attach;

if ($userconfig{'top_buttons'} == 2 && !@sub) {
	&show_buttons(1);
	print "<p>\n";
	}

print "<table width=100% border=1>\n";
print "<tr> <td $tb><table width=100% cellpadding=0 cellspacing=0><tr>",
      "<td><b>$text{'view_headers'}</b></td>\n";
if ($in{'headers'}) {
	print "<td align=right><a href='view_mail.cgi?idx=$in{'idx'}&headers=0&folder=$in{'folder'}$subs'>$text{'view_noheaders'}</a></td>\n";
	}
else {
	print "<td align=right><a href='view_mail.cgi?idx=$in{'idx'}&headers=1&folder=$in{'folder'}$subs'>$text{'view_allheaders'}</a></td>\n";
	}
print "</tr></table></td> </tr>\n";

print "<tr> <td $cb><table width=100%>\n";
if ($in{'headers'}) {
	# Show all the headers
	if ($mail->{'fromline'}) {
		print "<tr> <td><b>$text{'mail_rfc'}</b></td>",
		      "<td>",&eucconv(&html_escape($mail->{'fromline'})),
		      "</td> </tr>\n";
		}
	foreach $h (@{$mail->{'headers'}}) {
		print "<tr> <td><b>$h->[0]:</b></td> ",
		      "<td>",&eucconv(&html_escape(&decode_mimewords($h->[1]))),
		      "</td> </tr>\n";
		}
	}
else {
	# Just show the most useful headers
	print "<tr> <td><b>$text{'mail_from'}</b></td> ",
	      "<td>",&address_link($mail->{'header'}->{'from'}),"</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_to'}</b></td> ",
	      "<td>",&address_link($mail->{'header'}->{'to'}),"</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_cc'}</b></td> ",
	      "<td>",&address_link($mail->{'header'}->{'cc'}),"</td> </tr>\n"
		if ($mail->{'header'}->{'cc'});
	print "<tr> <td><b>$text{'mail_date'}</b></td> ",
	      "<td>",&eucconv(&html_escape($mail->{'header'}->{'date'})),
	      "</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_subject'}</b></td> ",
	      "<td>",&eucconv(&html_escape(&decode_mimewords(
			$mail->{'header'}->{'subject'}))),"</td> </tr>\n";
	}
print "</table></td></tr></table><p>\n";

# Show body attachment
if ($body) {
	print "<table width=100% border=1><tr><td $cb><pre>\n";
	foreach $l (&wrap_lines($body->{'data'}, $userconfig{'wrap_width'})) {
		print &link_urls(&eucconv(&html_escape($l))),"\n";
		}
	print "</pre></td></tr></table><p>\n";
	}

# Display other attachments
if (@attach) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'view_attach'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $a (@attach) {
		local $fn;
		$size = (int(length($a->{'data'})/1000)+1)." Kb";
		if ($a->{'type'} eq 'message/rfc822') {
			push(@titles, "$text{'view_sub'}<br>$size");
			}
		elsif ($a->{'filename'}) {
			push(@titles, &decode_mimewords($a->{'filename'}).
				      "<br>$size");
			$fn = &decode_mimewords($a->{'filename'});
			}
		else {
			push(@titles, "$a->{'type'}<br>$size");
			$a->{'type'} =~ /\/(\S+)$/;
			$fn = "file.$1";
			}
		$fn =~ s/ /_/g;
		$fn = &html_escape($fn);
		if ($a->{'type'} eq 'message/rfc822') {
			push(@links, "view_mail.cgi?idx=$in{'idx'}&folder=$in{'folder'}$subs&sub=$a->{'idx'}");
			}
		else {
			push(@links, "detach.cgi/$fn?idx=$in{'idx'}&folder=$in{'folder'}&attach=$a->{'idx'}$subs");
			}
		if ($userconfig{'thumbnails'} &&
		    ($a->{'type'} =~ /image\/gif/i && &has_command("giftopnm")&&
		     &has_command("pnmscale") && &has_command("cjpeg") ||
		     $a->{'type'} =~ /image\/jpeg/i && &has_command("djpeg") &&
		     &has_command("pnmscale") && &has_command("cjpeg"))) {
			# Can show an image icon
			push(@icons, "detach.cgi?scale=1&idx=$in{'idx'}&folder=$in{'folder'}&attach=$a->{'idx'}$subs");
			$imgicons++;
			}
		else {
			push(@icons, "images/boxes.gif");
			}
		}
	&icons_table(\@links, \@titles, \@icons, 8, undef,
		     $imgicons ? ( 0, 0 ) : ( ));
	print "</td></tr></table><p>\n";
	}

# Display GnuPG results
if (defined($sigcode)) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'view_gnupg'}</b></td> </tr>\n";
	print "<tr $cb> <td>";
	$sigmessage = &html_escape($sigmessage);
	$sigmessage = "<pre>$sigmessage</pre>" if ($sigcode == 4);
	print &text('view_gnupg_'.$sigcode, $sigmessage),"\n";
	if ($sigcode == 3) {
		local $url = "/$module_name/view_mail.cgi?idx=$in{'idx'}$subs";
		print "<p>",&text('view_recv', $sigmessage, "/gnupg/recv.cgi?id=$sigmessage&return=".&urlize($url)."&returnmsg=".&urlize($text{'view_return'})),"\n";
		}
	print "</td> </tr></table><p>\n";
	}
if ($deccode) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'view_crypt'}</b></td> </tr>\n";
	print "<tr $cb> <td>";
	print &text('view_crypt_'.$deccode, "<pre>$decmessage</pre>");
	print "</td> </tr></table><p>\n";
	}

if (@sub) {
	print "<input type=submit value=\"$text{'view_print'}\" name=print>\n";
	}
else {
	&show_buttons(2);
	}
print "</form>\n";

dbmclose(%read);

print "<hr>\n";
local @sr = !@sub ? ( ) :
    ( "view_mail.cgi?idx=$in{'idx'}", $text{'view_return'} ),
$s = int((@mail - $in{'idx'} - 1) / $userconfig{'perpage'}) *
	$userconfig{'perpage'};
&footer(@sub ? ( "view_mail.cgi?idx=$in{'idx'}&folder=$in{'folder'}",
		 $text{'view_return'} ) : ( ),
	"index.cgi?folder=$in{'folder'}", $text{'mail_return'});

# show_buttons(pos)
sub show_buttons
{
if ($folder->{'sent'} || $folder->{'drafts'}) {
	print "<input type=submit value=\"$text{'view_enew'}\" name=enew>\n";
	}
else {
	print "<input type=submit value=\"$text{'view_reply'}\" name=reply>\n";
	print "<input type=submit value=\"$text{'view_reply2'}\" name=rall>\n";
	}
print "<input type=submit value=\"$text{'view_forward'}\" name=forward>\n";
if (!$folder->{'sent'} && !$folder->{'drafts'}) {
	$m = $read{$mail->{'header'}->{'message-id'}};
	print "&nbsp;&nbsp;&nbsp;\n";
	print "<input name=mark$_[0] type=submit value=\"$text{'view_mark'}\">\n";
	print "<select name=mode$_[0]>\n";
	foreach $i (0 .. 2) {
		printf "<option value=%d %s>%s\n",
			$i, $m == $i ? 'selected' : '', $text{"view_mark$i"};
		}
	print "</select>\n";
	}
print "&nbsp;&nbsp;&nbsp;\n";
print "<input type=submit value=\"$text{'view_delete'}\" name=delete>\n";
print "&nbsp;&nbsp;&nbsp;\n";
print "<input type=submit value=\"$text{'view_print'}\" name=print>\n";
}

# address_link(address)
sub address_link
{
local @addrs = &split_addresses(&decode_mimewords($_[0]));
local @rv;
foreach $a (@addrs) {
	if ($inbook{$a->[0]}) {
		push(@rv, &html_escape($a->[2]));
		}
	else {
		push(@rv, "<a href='add_address.cgi?addr=".&urlize($a->[0]).
			  "&name=".&urlize($a->[1])."&idx=$in{'idx'}".
			  "&folder=$in{'folder'}$subs'>".
			  &eucconv(&html_escape($a->[2]))."</a>");
		}
	}
return join(" , ", @rv);
}

