#!/usr/local/bin/perl
# search.cgi
# Search for manual pages, and display a list of matches or an exact page

require './man-lib.pl';
use Config;
&ReadParse();
$in{'for'} || &error($text{'search_efor'});

@for = split(/\s+/, $in{'for'});
@howto = split(/\s+/, $config{'howto_dir'});
@doc = split(/\s+/, $config{'doc_dir'});
foreach $s (split(/\0/, $in{'section'})) {
	if ($s =~ /^([^:]+):(.*)/) {
		$section{$1}++;
		$opts{$1} = $2;
		}
	else {
		$section{$s}++;
		}
	}
if ($in{'check'} && $config{'check'}) {
	@check = split(/\s+/, $config{'check'});
	foreach $s (keys %section) {
		delete($section{$s}) if (&indexof($s, @check) < 0);
		}
	}

if ($section{'doc'}) {
	# Look in the system documentation directory (usually /usr/doc)
	foreach $d (@doc) {
		push(@rv, map { [ $text{'search_doc'},
				   "view_doc.cgi?file=".&urlize($_->[0]),
				   substr($_->[0], length($d)+1),
				   $_->[1], 1 ] }
			     &find_contents($d, \@for,
					    $howto[0], 1, $in{'exact'}));
		}
	}
if ($section{'custom'}) {
	# Look in the custom documentation directory
	push(@rv, map { [ $text{'search_custom'},
			   "view_doc.cgi?file=".&urlize($_->[0]),
			   substr($_->[0], length($config{'custom_dir'})+1),
			   $_->[1], 1 ] }
		     &find_contents($config{'custom_dir'}, \@for,
				    $howto[0], 1, $in{'exact'}));
	}
if ($section{'howto'}) {
	# Look in the HOWTO directory
	foreach $h (@howto) {
		push(@rv, map { [ $text{'search_howto'},
			      "view_howto.cgi?file=".&urlize($_->[0]),
			      $_->[2], $_->[1], 2 ] }
		     &find_contents($h, \@for, undef, 0, $in{'exact'}));
		}
	@rv = grep { $_->[2] !~ /^index/i } @rv;
	}
if ($section{'kernel'}) {
	# Look in the linux kernel Documentation directory
	 push(@rv, map { [ $text{'search_kernel'},
			   "view_kernel.cgi?file=".&urlize($_->[0]),
			   substr($_->[0], length($config{'kernel_dir'})+1),
			   $_->[1], 1 ] }
		     &find_contents($config{'kernel_dir'}, \@for,
				    undef, 1, $in{'exact'}));
	}
if ($section{'kde'}) {
	# Look in the KDE documentation directory
	 push(@rv, map { [ $text{'search_kde'},
			   "view_kde.cgi?file=".&urlize($_->[0]),
			   substr($_->[0], length($config{'kde_dir'})+1),
			   $_->[1], 1 ] }
		     &find_contents($config{'kde_dir'}, \@for,
				    undef, 1, $in{'exact'}));
	}
if ($section{'perl'}) {
	if ($in{'exact'}) {
		# Check for an exact module name match
		local @f = $in{'and'} ? ( $for[0] ) : @for;
		foreach $f (@f) {
			chop($out = `$perl_doc -l $f 2>/dev/null`);
			if ($out) {
				local $doc = &parse_perl_module($out);
				$doc->{'name'} =~ s/^\s*(\S+)\s+-\s+//;
				push(@rv, [ $text{'search_perl'},
					    "view_perl.cgi?mod=$f",
					    $f, $doc->{'name'}, 1 ]);
				}
			}
		}
	else {
		# Search the text of all perl modules
		foreach $d ($Config{'sitelib'}, $Config{'privlib'}) {
			open(FIND, "find $d -name '*.pm' -print |");
			while($path = <FIND>) {
				chop($path);
				local $doc = &parse_perl_module($path);
				local ($any = 0, $all = 1);
				foreach $f (@for) {
					if ($doc->{'name'} !~ /$f/i &&
					    $doc->{'description'} !~ /$f/i) {
						$all = 0;
						}
					else {
						$any = 1;
						}
					}
				next if (!$all && $in{'and'} || !$any);

				$doc->{'name'} =~ s/^\s*(\S+)\s+-\s+//;
				local $modfile =
				   `$perl_doc -l $doc->{'package'} 2>/dev/null`;
				if ($doc->{'package'} && $modfile) {
					push(@rv, [ $text{'search_perl'},
					  "view_perl.cgi?mod=$doc->{'package'}",
					  $doc->{'package'}, $doc->{'name'},
					  1 ]);
					}
				}
			close(FIND);
			}
		}
	}
if ($section{'help'}) {
	# Look in the webmin module help pages
	opendir(DIR, "..");
	foreach $m (readdir(DIR)) {
		# Is this a module with help
		local $dir = "../$m/help";
		next if (!-d $dir || $m =~ /^\./ || -l "../$m");
		local %minfo = &get_module_info($m);
		next if (!%minfo || !&check_os_support(\%minfo));

		# Check the help pages
		local @pfx;
		opendir(DIR, $dir);
		while($f = readdir(DIR)) {
			push(@pfx, $1) if ($f =~ /^([^\.]+)\.html$/);
			}
		closedir(DIR);
		HELP: foreach $p (&unique(@pfx)) {
			local $file = &help_file($m, $p);
			open(HELP, $file);
			local @st = stat($file);
			read(HELP, $help, $st[7]);
			close(HELP);
			if ($help =~ /<header>([^<]+)<\/header>/) {
				$header = $1;
				}
			else { next; }
			$help =~ s/<include\s+(\S+)>/inchelp($1)/ge;
			$help =~ s/<[^>]+>//g;
			local $matches = 0;
			if ($in{'exact'}) {
				# Just check header
				foreach $f (@for) {
					$matches++ if ($header =~ /\Q$f\E/i);
					}
				}
			else {
				# Check entire body
				foreach $f (@for) {
					$matches++ if ($help =~ /\Q$f\E/i);
					}
				}
			if (($in{'and'} && $matches == @for) ||
			    (!$in{'and'} && $matches)) {
				push(@rv, [ $text{'search_help'},
					    "/help.cgi/$m/$p?x=1",
					    "$m/$p", $header,
					    2 ]);
				}
			}
		}
	}
if ($section{'man'}) {
	# Look in manual pages (searches are never exact)
	$cmd = $config{'search_cmd'};
	map { s/\\/\\\\/g; s/'/\\'/g; } @for;
	if ($in{'and'}) {
		$cmd =~ s/PAGE/'$for[0]'/;
		}
	else {
		local $fors = join(" ", map { "'$_'" } @for);
		$cmd =~ s/PAGE/$fors/;
		}
	if ($opts{'man'}) {
		$ENV{'MANPATH'} .= $config{'man_dir'}.':'.$opts{'man'};
		}
	open(MAN, "$cmd |");
	while(<MAN>) {
		if (/(([^,\s]+).*)\s*\((\S+)\)\s+-\s+(.*)/ &&
		    !$done{$2,$3}++) {
			local ($page, $sect, $desc) = ($1, $3, $4);
			local @pp = split(/[\s+,]/, $page);
			map { s/\((\S+)\)//; } @pp;

			# Keywords must be page name or desc
			local ($any = 0, $all = 1, $exact);
			foreach $f (@for) {
				if ($desc !~ /$f/i && $page !~ /$f/i &&
				    &indexof($f, @pp) < 0) {
					$all = 0;
					}
				else {
					$any = 1;
					}
				$exact++ if (&indexof($f, @pp) >= 0);
				}
			next if (!$all && $in{'and'} || !$any);

			push(@rv, [ $text{'search_man'},
				    "view_man.cgi?page=$pp[0]&sec=$3&opts=".
				    $opts{'man'}, "$pp[0] ($sect)", $desc,
				    $exact ? 4 : 3 ]);
			}
		}
	close(MAN);
	}
if ($section{'google'}) {
	# Try to call the Google search engine
	local ($grv, $error);
	local $j = $in{'and'} ? ' and ' : ' or ';
	&http_download($google_host, $google_port, "$google_page?q=".
		       &urlize(join($j, @for))."&sourceid=webmin&num=20",
		       \$grv, \$error);
	if (!$error) {
		# Parse the results
		while($grv =~ /<p[^>]*><a[^>]+href=([^>]+)>([\000-\377]+?)<\/a>([\000-\377]*)$/i) {
			$grv = $3;
			local ($url = $1, $desc = $2);
			$desc =~ s/<\/?b>//g;
			local $matches = 0;
			foreach $f (@for) {
				$matches++ if ($desc =~ /\Q$f\E/i);
				}
			if (!$in{'exact'} ||
			    ($in{'and'} && $matches == @for) ||
			    (!$in{'and'} && $matches)) {
				push(@rv, [ $text{'search_google'}, $url, length($url) > 60 ? substr($url, 0, 60)."..." : $url, $desc, 0.5 ]);
				}
			}
		}
	}

if (@rv == 1 && !$in{'check'}) {
	# redirect to the exact page
	&redirect($in{'exact'} ? $rv[0]->[1]
			       : "$rv[0]->[1]&for=".&urlize($in{'for'}));
	exit;
	}

# Display search results
&header($text{'search_title'}, "");
$for = join($in{'and'} ? " and " : " or ", map { "<tt>$_</tt>" } @for);
print "<center><font size=+1>",&text('search_for', $for),
      "</font></center>\n";
print "<hr>\n";
if (@rv) {
	#@rv = sort { $b->[4] <=> $a->[4] } @rv;
	@rv = sort { &ranking($b) <=> &ranking($a) } @rv;
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'search_file'}</b></td> ",
	      "<td><b>$text{'search_type'}</b></td> ",
	      "<td><b>$text{'search_desc'}</b></td> </tr>\n";
	foreach $r (@rv) {
		print "<tr $cb>\n";
		if ($r->[1] =~ /^(http|ftp|https):/) {
			print "<td><a href='$r->[1]'>",&html_escape($r->[2]),
			      "</a></td>\n";
			}
		else {
			print "<td><a href='$r->[1]&for=".&urlize($in{'for'}).
			      "'>",&html_escape($r->[2]),"</a></td>\n";
			}
		print "<td nowrap>$r->[0]</td>\n";
		print "<td>",$r->[3] ? &html_escape($r->[3]) :"<br>","</td>\n";
		print "</tr>\n";
		}
	print "</table><p>\n";
	}
else {
	print "<p><b>",&text('search_none', "<tt>$in{'for'}</tt>"),"</b><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

# find_contents(directory, &strings, [exclude], [descend], [nameonly])
# Find some string in a directory of files
sub find_contents
{
opendir(DIR, $_[0]);
local @f = readdir(DIR);
closedir(DIR);
local @rv;
foreach $f (@f) {
	next if ($f =~ /^\./);
	local $p = "$_[0]/$f";
	next if ($p eq $_[2]);
	if (-d $p) {
		# go into subdirectory
		push(@rv, &find_contents($p, $_[1], $_[2], $_[3], $_[4]))
			if ($_[3]);
		}
	else {
		# Skip non-text or HTML files
		local $ff = $f;
		$ff =~ s/\.(gz|bz|bz2)$//i;
		next if ($ff !~ /\.(txt|htm|html|doc)$/ &&
			 $ff =~ /\.[A-Za-z0-9]+$/);
		next if ($ff =~ /(^makefile$)|(^core$)/i);

		local $matches = 0;
		foreach $s (@{$_[1]}) {
			$matches++ if ($p =~ /\Q$s\E/i);
			}
		if ($_[4]) {
			# just compare filename
			if ($in{'and'} && $matches == @{$_[1]} ||
			    !$in{'and'} && $matches) {
				local ($desc, $data) = &read_doc_file($p);
				if ($desc !~ /^#!/ && $desc !~ /^#\%/) {
					push(@rv, [ $p, $desc, $f, $matches ]);
					}
				}
			}
		else {
			# compare file contents
			local ($desc, $data) = &read_doc_file($p);
			local $dmatches = 0;
			foreach $s (@{$_[1]}) {
				$dmatches++ if ($data =~ /\Q$s\E/i);
				}
			if (($in{'and'} && $dmatches == @{$_[1]} ||
			     !$in{'and'} && $dmatches) &&
			    $desc !~ /^#!/ && $desc !~ /^#\%/) {
				push(@rv, [ $p, $desc, $f, $matches ]);
				}
			}
		}
	}
return @rv;
}

# read_doc_file(filename)
# Returns desc, data
sub read_doc_file
{
local ($two, $first, $title, $data);
open(FILE, $_[0]);
read(FILE, $two, 2);
if ($two eq "\037\213") {
	close(FILE);
	open(FILE, "gunzip -c $p |");
	}
elsif ($two eq "BZ") {
	close(FILE);
	open(FILE, "bunzip2 -c $p |");
	}
seek(FILE, 0, 0);
while(<FILE>) {
	$data .= $_;
	if (/[A-Za-z0-9]/ && !/\$\S+:/ && !$first) {
		chop($first = $_);
		$first =~ s/.\010//g;
		}
	}
close(FILE);
if ($data =~ /<\s*title\s*>([\000-\177]{0,200})<\s*\/\s*title\s*>/i) {
	$title = $1;
	}
return ($title ? $title : $first =~ /<.*>/ ? undef : $first, $data);
}

# parse_perl_module(file)
sub parse_perl_module
{
local (%doc, $inside);
open(MOD, $_[0]);
while(<MOD>) {
	if (/^\s*package\s+(\S+)\s*;/ && !$doc{'package'}) {
		$doc{'package'} = $1;
		}
	elsif (/^=head1\s+(\S+)/i) {
		$inside = $1;
		}
	elsif (/^=cut/i) {
		undef($inside);
		}
	elsif ($inside) {
		$doc{lc($inside)} .= $_;
		}
	}
close(MOD);
return \%doc;
}

# help_file(dir, prefix)
sub help_file
{
local $o;
foreach $o (@lang_order_list) {
	local $lang = "$_[0]/$_[1].$current_lang.html";
	return $lang if (-r $lang);
	}
return "$_[0]/$_[1].html";
}

# inchelp(path)
sub inchelp
{
local $inc;
local $ipath = &help_file($dir, $_[0]);
open(INC, $ipath) || return "<i>".&text('search_einclude', $_[0])."</i><br>\n";
local @st = stat(INC);
read(INC, $inc, $st[7]);
close(INC);
return $inc;
}

sub ranking
{
local ($name = 0, $desc = 0);
foreach $f (@for) {
	$desc++ if ($_[0]->[3] =~ /$f/i);
	$name++ if ($_[0]->[1] =~ /$f/i);
	}
return $name ? $_[0]->[4] * 10 :
       $desc ? $_[0]->[4] :
	       $_[0]->[4] / 10;
}

