#!/usr/local/bin/perl
# index.cgi
# Display all existing databases

require './mysql-lib.pl';

# Check for MySQL programs
if (!-x $config{'mysqladmin'}) {
	&header($text{'index_title'}, "", "intro", 0, 1);
	print "<hr>\n";
	print "<p>",&text('index_eadmin', "<tt>$config{'mysqladmin'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
if (!-x $config{'mysql'}) {
	&header($text{'index_title'}, "", "intro", 0, 1);
	print "<hr>\n";
	print "<p>",&text('index_esql', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$out = `$config{'mysql'} -V 2>&1`;
if ($out =~ /lib\S+\.so/) {
	&header($text{'index_title'}, "", "intro", 0, 1);
	print "<hr>\n";
	print "<p>",&text('index_elibrary', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
elsif ($out !~ /distrib\s+((3|4)\.[0-9\.]*)/i) {
	&header($text{'index_title'}, "", "intro", 0, 1);
	print "<hr>\n";
	print "<p>",&text('index_ever', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$ver = $1;
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

if (!$userconfig{'login'}) {
	# User has not set his password yet
	$needpass = 1;
	}
else {
	$r = &is_mysql_running();
	if ($r == 0) {
		# Not running
		print "<p> <b>$text{'index_notrun'}</b> <p>\n";
		}
	elsif ($r == -1) {
		# Running, but wrong password
		$needpass = 1;
		}
	else {
		# Running .. list databases
		print "<h3>$text{'index_dbs'}</h3>\n";
		@titles = grep { &can_edit_db($_) } &list_databases();
		@icons = map { "images/db.gif" } @titles;
		@links = map { "edit_dbase.cgi?db=$_" } @titles;
		if (!@titles) {
			print "<b>$text{'index_nodbs'}</b> <p>\n";
			}
		elsif ($config{'style'}) {
			@tables = map { @t = &list_tables($_); scalar(@t) }
				      @titles;
			@titles = map { &html_escape($_) } @titles;
			&split_table([ $text{'index_db'}, $text{'index_tables'} ],
				     \@links, \@titles, \@tables) if (@titles);
			}
		else {
			@titles = map { &html_escape($_) } @titles;
			&icons_table(\@links, \@titles, \@icons);
			}

		# Check if the user can create databases
		#print "<a href=newdb_form.cgi>$text{'index_add'}</a> <p>\n";
		}
	}

if ($needpass) {
	# Need to ask for the password
	print "<p> <b>$text{'index_nopass'}</b> <p>\n";
	print "<form action=login.cgi>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'index_ltitle'}</b></td> </tr>\n";
	print "<tr $cb> <td><table cellpadding=2>\n";
	print "<tr> <td><b>$text{'index_login'}</b></td>\n";
	printf "<td><input name=login size=20 value='%s'></td> </tr>\n",
		$userconfig{'login'} ? $userconfig{'login'} : $remote_user;
	print "<tr> <td><b>$text{'index_pass'}</b></td>\n";
	printf "<td><input name=pass size=20 type=password value='%s'></td>\n",
		$userconfig{'pass'};
	print "</tr> </table></td></tr></table>\n";
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=reset value='$text{'index_clear'}'>\n";
	print "</center></form>\n";

	}

print "<hr>\n";
&footer("/", "index");

