#!/usr/local/bin/perl
# uconfig.cgi
# Like config.cgi, but works on a user's personal config file

require './web-lib.pl';
$m = $ARGV[0];
&init_config();
&switch_to_remote_user();
&create_user_config_dirs();

%module_info = &get_module_info($m);
&header($text{'config_title'}, "", undef, 0, 1);
print "<center><font size=+2>",&text('config_dir', $module_info{'desc'}),
      "</font></center>\n";
print "<hr>\n";

print "<form action=\"uconfig_save.cgi\">\n";
print "<input type=hidden name=module value=\"$m\">\n";
print "<table border>\n";
print "<tr $tb> <td><b>",&text('config_header', $module_info{'desc'}),
      "</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
&read_file("$m/defaultuconfig", \%config);
&read_file("$config_directory/$m/uconfig", \%config);
&read_file("$user_config_directory/$m/config", \%config);

if (-r "$m/uconfig_info.pl") {
	# Module has a custom config editor
	&foreign_require($m, "uconfig_info.pl");
	&foreign_call($m, "config_form", \%config);
	}
else {
	# Use config.info to create config inputs
	&read_file("$m/uconfig.info", \%info, \@info_order);
	%einfo = %info;
	foreach $o (@lang_order_list) {
		&read_file("$m/uconfig.info.$o", \%info, \@info_order);
		}
	@info_order = &unique(@info_order);

	foreach $c (@info_order) {
		@p = split(/,/, $info{$c});
		@ep = split(/,/, $einfo{$c});
		if (scalar(@ep) > scalar(@p)) {
			push(@p, @ep[scalar(@p) .. @ep-1]);
			}
		if ($p[1] == 11) {
			print "<tr><td colspan=3 $tb>\n" ;
			print "\t<b>" . $p[0] . "</b>\n</td></tr>\n" ;
			next;
			}
		print "<tr> <td valign=top><b>$p[0]</b></td>\n";
		print "<td nowrap>\n";
		$qw = $config{$c} =~ /'/ ? '"' : "'";
		if ($p[1] == 0 || $p[1] == 12) {
			$size = $p[2] ? "size=$p[2]" : "size=40";
			$max = $p[3] ? "maxlength=$p[3]" : "";
			$type = $p[1] == 12 ? "type=password" : "";
			print "<input name=\"$c\" $size $max $type value=$qw$config{$c}$qw>\n";
			}
		elsif ($p[1] == 1) {
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S*)\-(.*)$/;
				printf "<input type=radio name=\"$c\" value='$1' %s>\n",
					$config{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				}
			}
		elsif ($p[1] == 2) {
			local %sel;
			map { $sel{$_}++ } split(/,/, $config{$c});
			print "<select name=\"$c\" size=4 multiple>\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$sel{$1} ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 3) {
			$none = $p[2] ? $p[2] : $text{'config_none'};
			printf "<input type=radio name=\"%s_none\" value=1 %s> $none\n",
				$c, $config{$c} eq "" ? "checked" : "";
			print "&nbsp;&nbsp;\n";
			printf "<input type=radio name=\"%s_none\" value=0 %s>\n",
				$c, $config{$c} eq "" ? "" : "checked";
			print "<input name=\"$c\" size=20 value=$qw$config{$c}$qw>\n";
			}
		elsif ($p[1] == 4) {
			print "<select name=\"$c\">\n";
			for($i=2; $i<@p; $i++) {
				$p[$i] =~ /^(\S+)\-(.*)$/;
				printf "<option value=\"$1\" %s>$2\n",
					$config{$c} eq $1 ? "selected" : "";
				}
			print "</select>\n";
			}
		elsif ($p[1] == 5) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $config{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $config{$c} eq "" ? "" : "checked";
				}
			print &unix_user_input($c, $config{$c});
			}
		elsif ($p[1] == 6) {
			if ($p[2]) {
				printf
				   "<input type=radio name=${c}_def value=1 %s>$p[2]\n",
				   $config{$c} eq "" ? "checked" : "";
				printf "<input type=radio name=${c}_def value=0 %s>\n",
				   $config{$c} eq "" ? "" : "checked";
				}
			print &unix_group_input($c, $config{$c});
			}
		elsif ($p[1] == 7) {
			print "<input name=\"$c\" size=40 value=$qw$config{$c}$qw> ",
			      &file_chooser_button($c, 1);
			}
		elsif ($p[1] == 8) {
			print "<input name=\"$c\" size=40 value=$qw$config{$c}$qw> ",
			      &file_chooser_button($c, 0);
			}
		elsif ($p[1] == 9) {
			local $cols = $p[2] ? $p[2] : 40;
			local $rows = $p[3] ? $p[3] : 5;
			print "<textarea name=\"$c\" rows=$rows cols=$cols>",
				join("\n", split(/\s+/, $config{$c})),
				"</textarea>\n";
			}
		elsif ($p[1] == 10) {
			local $fv = $config{$c};
			for($i=2; $i<@p; $i++) {
				($p[$i] =~ /^(\S+)\-(.*)$/) || next;
				printf "<input type=radio name=\"$c\" value=$1 %s>\n",
					$config{$c} eq $1 ? "checked" : "";
				print "$2 &nbsp;&nbsp;\n";
				$fv = undef if ($config{$c} eq $1);
				}
			printf "<input type=radio name=\"$c\" value=free %s>\n",
				$fv ? "checked" : "";
			if ($p[$#p] !~ /^(\S*)\-(.*)$/) {
				print $p[$#p],"\n";
				}
			print "<input name=\"${c}_free\" value='$fv'>\n";
			}
		print "</td> </tr>\n";
		}
	}
print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";
print "<hr>\n";
&footer("/$m", $text{'index'});

