/*
 *      %W%       TriChlor: %G% %U%
 */

#ifndef _VNCOMPOSE_H_
#define _VNCOMPOSE_H_

#include "charset.h"
#include "portable.h"

/* States in the composition machine */
#define CO_ST_LEVEL1	0
#define CO_ST_LEVEL2	1
#define CO_ST_LEVEL3	2

#define CO_BREVE	C_left_parenthesis
#define CO_CIRCUMFLEX	C_caret
#define CO_HORN		C_plus_sign

#define CO_ACUTE	C_apostrophe
#define CO_GRAVE	C_backquote
#define CO_HOOK_ABOVE	C_question_mark
#define CO_TILDE	C_tilde
#define CO_DOT_BELOW	C_period

typedef struct {
    u_char	state;		/* internal state of composition machinery */
    u_char	c1, c2, c3;	/* storage for composite characters */
    u_char	i1, i2, i3;	/* storage for corresponding icodes (see algorithm) */
    u_char	breve, circumflex, horn; /* current modifiers */
    u_char	acute, grave, hook_above, tilde, dot_below; /* current tone marks */
} Co_Data;


#ifdef ANSI_C
/* compose character by character */
extern u_char FAR PASCAL	vncompose(Co_Data FAR *data, u_char inchar, int FAR *fl_compose, int FAR *fl_erase);
/* initialize tables */
extern void FAR PASCAL		vncompose_init(Co_Data FAR *data);
/* set the diacritic character mnemonic */
extern int FAR PASCAL		vncompose_set(int diacritic, u_char newchar, Co_Data FAR *Co_data);

#else

extern u_char FAR PASCAL	vncompose();
extern void FAR PASCAL		vncompose_init();
extern int FAR PASCAL		vncompose_set();
#endif

#endif /* _VNCOMPOSE_H_ */
