/*
 *      %W%       TriChlor: %G% %U%
 */

#ifndef _VNKEYS_H_
#define _VNKEYS_H_

#include "portable.h"
#include "vncompos.h"	/* for Co_data declaration below */

/* maximum number of processing engines going at the same time */
#define VK_MAX_FSMS		3

#define VK_ST_VIETNAMESE	0
#define VK_ST_ENGLISH		1
#define VK_ST_LITERAL		2
#define VK_ST_ESC_VIETMY	3
#define VK_ST_ESC_LITERAL	4
#define VK_ST_EXPLICIT_COMPOSE	5

#define VK_DEFAULT_ESC		'\\'
#define	VK_DEFAULT_BS		'\010'	/* BS used in IMMEDIATE mode */

#define	VK_ESC_VIETNAMESE_1	'V'
#define	VK_ESC_VIETNAMESE_2	'v'
#define	VK_ESC_ENGLISH_1	'M'
#define	VK_ESC_ENGLISH_2	'm'
#define	VK_ESC_LITERAL_1	'L'
#define	VK_ESC_LITERAL_2	'l'

#define	VK_GET_STATE		0x1
#define	VK_GET_ESC		0x2
#define	VK_GET_BS		0x4
#define	VK_GET_BATCH		0x8

#define	VK_SET_STATE		0x1
#define	VK_SET_ESC		0x2
#define	VK_SET_BS		0x4
#define	VK_SET_BATCH		0x8

typedef int			Vk_Fsm;
typedef int     		Vk_State;

extern Co_Data FAR		Co_data[]; /* storage area for composition machiner */
/* Convenience macro */
#define vk_set_diacritic(id, diacritic, character)	vncompose_set(diacritic, character, &(Co_data[id]));
#define vk_get_breve(id)	(Co_data[id].breve)
#define vk_get_circumflex(id)	(Co_data[id].circumflex)
#define vk_get_horn(id)		(Co_data[id].horn)
#define vk_get_acute(id)	(Co_data[id].acute)
#define vk_get_grave(id)	(Co_data[id].grave)
#define vk_get_hook_above(id)	(Co_data[id].hook_above)
#define vk_get_tilde(id)	(Co_data[id].tilde)
#define vk_get_dot_below(id)	(Co_data[id].dot_below)

#ifdef ANSI_C
/* initialize the FSM */
extern Vk_Fsm FAR PASCAL 	vk_init(Vk_State st, u_char com, u_char bs);
/* step through it */
extern Vk_State FAR PASCAL	vk_step(Vk_Fsm id, u_char inkey, u_char FAR outchars[], int FAR *outcount);
/* query its status */
extern void FAR PASCAL		vk_get(Vk_Fsm id, u_int FAR *value, int get_flag);
/* set its status */
extern void FAR PASCAL		vk_set(Vk_Fsm id, u_int value, int set_flag);
/* flush it */
extern void FAR PASCAL		vk_flush(Vk_Fsm id, u_char FAR *outchars, int FAR *outcount);
extern void FAR PASCAL		vk_end(Vk_Fsm id, u_char FAR *outchars, int FAR *outcount);
/* parse standard arguments */
extern void FAR PASCAL		vk_parse_args(int FAR *ac, char FAR *av[], u_char FAR *com, u_char FAR *bs);

/* convert VK to 8-bit data */
extern int FAR PASCAL		vk_qrto8(u_char FAR *inbuf, u_char FAR *outbuf, u_char esc, Vk_State state);
/* convert 8- to VK data */
extern int FAR PASCAL		vk_8toqr(u_char FAR *inbuf, u_char FAR *outbuf, u_char esc, Vk_State state);
#else
extern Vk_Fsm FAR PASCAL 	vk_init();
extern Vk_State FAR PASCAL	vk_step();
extern void FAR PASCAL		vk_get();
extern void FAR PASCAL		vk_set();
extern void FAR PASCAL		vk_flush();
extern void FAR PASCAL		vk_end();
extern void FAR PASCAL		vk_parse_args();
extern int FAR PASCAL		vk_qrto8();
extern int FAR PASCAL		vk_8toqr();
#endif

#endif /* _VNKEYS_H_ */
