/*****************************************************************
    ViewKlass - C++ framework library for Motif

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Copyright (C) 2001 John Lemcke
    jlemcke@bigfoot.com
*****************************************************************/

/**
 *
 * $Id: VkPrefToggle.h,v 1.2 2002/01/22 12:36:56 jostle Exp $
 *
 * This file contains the class definition for VkPrefToggle,
 * the class which allows the programmer to define 
 * toggle button widgets in preference dialogs.
 *
 *
 *
 **/

#ifndef VKPREFTOGGLE_H
#define VKPREFTOGGLE_H

#include <Xm/ToggleB.h>
#include <Vk/VkConfig.h>
#include <Vk/VkPrefItem.h>

class VkPrefToggle : public VkPrefItem {
public:

    VkPrefToggle(const char *name, Boolean forceLabelFormat = False);
	
	Boolean getValue(void);
    void setValue(Boolean value);

    Boolean changed();

	Widget buildLabel();
	
    VkPrefItemType type() { return PI_toggle; }
    Boolean isContainer() { return False; }
	virtual const char *className() { return "VkPrefToggle"; }

private:
    Boolean _value;
	Boolean _forceLabelFormat;
	void instantiate(Widget parent);
};
 
#endif // VKPREFTOGGLE_H
