ldap_oc = {
  'dSA':{
    'requires':['objectClass','presentationAddress','cn'],
    'allows':['knowledgeInformation']
  },
  'applicationEntity':{
    'requires':['objectClass','presentationAddress','cn'],
    'allows':['description','l','o','ou','seeAlso','supportedApplicationContext']
  },
  'newPilotPerson':{
    'requires':['objectClass','sn','cn'],
    'allows':[
      'businessCategory','description','drink','homePhone',
      'homePostalAddress','janetMailbox','mail','mailPreferenceOption',
      'mobile','organizationalStatus','otherMailbox','pager',
      'personalSignature','personalTitle','preferredDeliveryMethod',
      'roomNumber','secretary','seeAlso','telephoneNumber',
      'textEncodedORaddress','uid','userClass','userPassword'
    ]
  },
  'pilotPerson':{
    'requires':['objectClass','sn','cn'],
    'allows':[
       'uid','textEncodedORAddress','mail','drink',
       'roomNumber','userClass','homePhone','homePostalAddress',
       'secretary','personalTitle','preferredDeliveryMethod',
       'businessCategory','janetMailbox','otherMailbox',
       'mobile','pager','organizationalStatus',
       'mailPreferenceOption','personalSignature'
    ]
  },
  'simpleSecurityObject':{
    'requires':['objectClass','userPassword'],
    'allows':[]
  },
  'referral':{
    'requires':['ref','objectClass'],
    'allows':[]
  },
  'uidobject':{
    'requires':['objectClass','uid'],
    'allows':[]
  },
  'organization':{
    'requires':['objectClass','o'],
    'allows':[
      'businessCategory','description','destinationIndicator',
      'facsimileTelephoneNumber','internationaliSDNNumber','l',
      'physicalDeliveryOfficeName','postOfficeBox','postalAddress',
      'postalCode','preferredDeliveryMethod','registeredAddress',
      'searchGuide','seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','userPassword','x121Address'
    ]
  },
  'nisNetgroup':{
    'requires':['cn'],
    'allows':['nisNetgroupTriple','memberNisNetgroup','description']
  },
  'posixAccount':{
    'requires':['cn','uid','uidNumber','gidNumber','homeDirectory'],
    'allows':['userPassword','loginShell','gecos','description']
  },
  'documentSeries':{
    'requires':['objectClass','cn'],
    'allows':['description','l','o','ou','seeAlso','telephoneNumber']
  },
  'organizationalPerson':{
    'requires':['objectClass','sn','cn'],
    'allows':[
      'description','destinationIndicator','facsimileTelephoneNumber',
      'internationaliSDNNumber','l','ou','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','title','userPassword',
      'x121Address'
    ]
  },
  'cacheObject':{
    'requires':['objectClass'],
    'allows':['ttl']
  },
  'country':{
    'requires':['objectClass','c'],
    'allows':['searchGuide','description']
  },
  'restaurant':{
    'requires':['objectClass','description','telephoneNumber','streetAddress'],
    'allows':[
      'Ambiance','Appearance','Average-price','Closed','CreditCardsAccepted',
      'Kosher','Max-price','MaximumInParty','Min-price','Music',
      'NotRecommended','OutdoorSeating','Parking','QualityOfService',
      'QualityPriceRatio','Recommended','RecommendedBy','Reservation',
      'ServiceSpeed','Specialty','Taux-de-frequentation','TransportationMeans',
      'facsimileTelephoneNumber','postalAddress'
    ]
  },
  'room':{
    'requires':['objectClass','cn'],
    'allows':['description','roomNumber','seeAlso','telephoneNumber']
  },
  'service':{
    'requires':['objectClass','cn'],
    'allows':[
      'category','dependentUpon','destinationIndicator',
      'facsimileTelephoneNumber','hoursOfOperation','internationaliSDNNumber',
      'jpegPhoto','keywords','labeledURI','mail','multiLineDescription',
      'owner','physicalDeliveryOfficeName','platform','postOfficeBox',
      'postalAddress','postalCode','preferredDeliveryMethod','product',
      'provider','ratingDescription','ratingTime','registeredAddress',
      'seeAlso','serviceArea','serviceRating','streetAddress',
      'telephoneNumber','teletexTerminalIdentifier','telexNumber',
      'x121Address'
    ]
  },
  'account':{
    'requires':['objectClass','uid'],
    'allows':['description','host','l','o','ou','seeAlso']
  },
  'bankArrangement':{
    'requires':['objectClass','cn','bankArrangementInfo'],
    'allows':['bankName','bankAccount','bankCodeNumber']
  },
  'organizationalUnit':{
    'requires':['objectClass','ou'],
    'allows':[
      'businessCategory','description','destinationIndicator',
      'facsimileTelephoneNumber','internationaliSDNNumber','l',
      'physicalDeliveryOfficeName','postOfficeBox','postalAddress',
      'postalCode','preferredDeliveryMethod','registeredAddress',
      'searchGuide','seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','userPassword','x121Address'
    ]
  },
  'ipProtocol':{
    'requires':['cn','ipProtocolNumber'],
    'allows':['description']
  },
  'device':{
    'requires':['objectClass','cn'],
    'allows':['description','l','o','ou','owner','seeAlso','serialNumber']
  },
  'rFC822localPart':{
    'requires':['objectClass','dc'],
    'allows':[
      'associatedName','businessCategory','cn','description',
      'destinationIndicator','facsimileTelephoneNumber',
      'internationaliSDNNumber','l','o','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','searchGuide','seeAlso','sn','st','streetAddress',
      'telephoneNumber','teletexTerminalIdentifier','telexNumber',
      'userPassword','x121Address'
    ]
  },
  'person':{
    'requires':['objectClass','sn','cn'],
    'allows':['description','seeAlso','telephoneNumber','userPassword']
  },
  'usStateOrEquivalent':{
    'requires':['objectClass','st','fipsStateAlphaCode','fipsStateNumericCode','l'],
    'allows':[
      'description','lastModifiedTime','nadfSearchGuide','searchGuide',
      'seeAlso','streetAddress','supplementaryInformation'
    ]
  },
  'usPlace':{
    'requires':['objectClass','fips55','l'],
    'allows':[
      'description','lastModifiedTime','nadfSearchGuide','searchGuide',
      'seeAlso','st','streetAddress','supplementaryInformation'
    ]
  },
  'bootableDevice':{
    'requires':[],
    'allows':['bootFile','bootParameter']
  },
  'domainRelatedObject':{
    'requires':['objectClass','associatedDomain'],
    'allows':[]
  },
  'nisMap':{
    'requires':['nisMapName'],
    'allows':['description']
  },
  'applicationProcess':{
    'requires':['objectClass','cn'],
    'allows':['description','l','ou','seeAlso']
  },
  'musician':{
    'requires':['objectClass','cn'],
    'allows':['musicalInstrument','band']
  },
  'nationalObject':{
    'requires':['objectClass','c'],
    'allows':[]
  },
  'residentialPerson':{
    'requires':['objectClass','sn','cn','l'],
    'allows':[
      'businessCategory','description','destinationIndicator',
      'facsimileTelephoneNumber','internationaliSDNNumber','l',
      'physicalDeliveryOfficeName','postOfficeBox','postalAddress',
      'postalCode','preferredDeliveryMethod','registeredAddress',
      'seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','userPassword','x121Address'
    ]
  },
  'publicObject':{
    'requires':['objectClass','namingLink'],
    'allows':[]
  },
  'friendlyCountry':{
    'requires':['objectClass','c','co'],
    'allows':['description','searchGuide']
  },
  'dcobject':{
    'requires':['objectClass','dc'],
    'allows':[]
  },
  'strongAuthenticationUser':{
    'requires':['objectClass','userCertificate'],
    'allows':['userCertificate;binary']
  },
  'ipNetwork':{
    'requires':['ipNetworkNumber'],
    'allows':['cn','ipNetmaskNumber','l','description','manager']
  },
  'document':{
    'requires':['objectClass','documentIdentifier'],
    'allows':['abstract','audio','authorCN','authorSN','cn','dITRedirect','description','documentAuthor','documentLocation','documentPublisher','documentStore','documentTitle','documentVersion','info','jpegPhoto','keywords','l','lastModifiedBy','lastModifiedTime','manager','o','obsoletedByDocument','obsoletesDocument','ou','photo','seeAlso','subject','uniqueIdentifier','updatedByDocument','updatesDocument']
  },
  'groupOfNames':{
    'requires':['objectClass','member','cn'],
    'allows':['businessCategory','description','o','ou','owner','seeAlso']
  },
  'ipService':{
    'requires':['cn','ipServicePort','ipServiceProtocol'],
    'allows':['description']
  },
  'image':{
    'requires':['objectClass','cn'],
    'allows':['citation','copyright','imageFiles','jpegPhoto','keywords','multiLineDescription','owner','predominantColor']
  },
  'documentDescription':{
    'requires':['objectClass','cn'],
    'allows':['labeledURI','multiLineDescription','owner']
  },
  'nisObject':{
    'requires':['cn','nisMapEntry','nisMapName'],
    'allows':['description']
  },
  'ansiOrgObject':{
    'requires':['objectClass','ansiOrgNumericCode'],
    'allows':[]
  },
  'shadowAccount':{
    'requires':['uid'],
    'allows':['userPassword','shadowLastChange','shadowMin','shadowMax','shadowWarning','shadowInactive','shadowExpire','shadowFlag','description']
  },
  'nisKeyObject':{
    'requires':['cn','nisPublicKey','nisSecretKey'],
    'allows':['uidNumber','description']
  },
  'domain':{
    'requires':['objectClass','dc'],
    'allows':[
      'associatedName','businessCategory','description',
      'destinationIndicator','facsimileTelephoneNumber',
      'internationaliSDNNumber','l','o','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','searchGuide','seeAlso','st','streetAddress',
      'telephoneNumber','teletexTerminalIdentifier','telexNumber',
      'userPassword','x121Address'
    ]
  },
  'inetOrgPerson':{
    'requires':['objectClass','sn','cn'],
    'allows':[
      'displayName','audio','businessCategory','carLicense','departmentNumber',
      'description','destinationIndicator','employeeNumber','employeeType',
      'facsimileTelephoneNumber','givenName','homePhone','homePostalAddress',
      'initials','internationaliSDNNumber','jpegPhoto','l','labeledURI','mail',
      'manager','mobile','ou','o','pager','photo','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'preferredLanguage','registeredAddress','roomNumber','secretary',
      'seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','title','uid',
      'userCertificate','userPKCS12','userPassword',
      'userSMIMECertificate','x121Address','x500uniqueIdentifier',
      'shortName','dayOfBirth','homePostalAddress',
    ]
  },
  'pilotOrganization':{
    'requires':['objectClass','ou','o'],
    'allows':[
      'buildingName','businessCategory','description','destinationIndicator',
      'facsimileTelephoneNumber','internationaliSDNNumber','l',
      'physicalDeliveryOfficeName','postOfficeBox','postalAddress',
      'postalCode','preferredDeliveryMethod','registeredAddress',
      'searchGuide','seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','userPassword','x121Address'
    ]
  },
  'umichDocument':{
    'requires':['objectClass','documentIdentifier'],
    'allows':['abstract','audio','authorCN','authorSN','category','cn','dITRedirect','description','documentAuthor','documentAvailable','documentLocation','documentPublisher','documentSeriesTitle','documentStore','documentTitle','documentVersion','info','jpegPhoto','keywords','l','labeledURI','lastModifiedBy','lastModifiedTime','manager','multiLineAbstract','o','obsoletedByDocument','obsoletesDocument','ou','owner','photo','platform','product','seeAlso','serviceArea','subject','uniqueIdentifier','updatedByDocument','updatesDocument']
  },
  'top':{
    'requires':['objectClass'],
    'allows':[]
  },
  'nadfApplicationEntity':{
    'requires':['objectClass','supportedApplicationContext','presentationAddress','cn'],
    'allows':['description','l','o','ou','seeAlso','supportedApplicationContext']
  },
  'dNSDomain':{
    'requires':['objectClass','dc'],
    'allows':[
      'associatedName','businessCategory','dNSRecord','description',
      'destinationIndicator','facsimileTelephoneNumber',
      'internationaliSDNNumber','l','o','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','searchGuide','seeAlso','st','streetAddress',
      'telephoneNumber','teletexTerminalIdentifier','telexNumber',
      'userPassword','x121Address'
    ]
  },
  'oncRpc':{
    'requires':['cn','oncRpcNumber'],
    'allows':['description']
  },
  'imageFile':{
    'requires':['objectClass','cn'],
    'allows':['colorDepth','documentLocation','fileFormat','fileSize','height','resolution','seeAlso','width']
  },
  'kerberosSecurityObject':{
    'requires':['objectClass','krbName'],
    'allows':[]
  },
  'organizationalRole':{
    'requires':['objectClass','cn'],
    'allows':[
      'description','destinationIndicator','facsimileTelephoneNumber',
      'internationaliSDNNumber','l','ou','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','roleOccupant','seeAlso','st','streetAddress',
      'telephoneNumber','teletexTerminalIdentifier','telexNumber',
      'x121Address'
    ]
  },
  'certificationAuthority':{
    'requires':['objectClass','cACertificate'],
    'allows':[
      'authorityRevocationList',
      'certificateRevocationList',
      'crossCertificatePair'
      'cACertificate;binary',
      'authorityRevocationList;binary',
      'certificateRevocationList;binary',
      'crossCertificatePair;binary'
    ]
  },
  'alias':{
    'requires':['aliasedObjectName','objectClass'],
    'allows':[]
  },
  'labeledURIObject':{
    'requires':['objectClass'],
    'allows':['labeledURI']
  },
  'ipHost':{
    'requires':['cn','ipHostNumber'],
    'allows':['l','description','manager','userPassword']
  },
  'umichPerson':{
    'requires':['objectClass','sn','cn','universityID'],
    'allows':[
      'affiliationCode','audio','businessCategory','classStanding',
      'description','destinationIndicator','doNotDelete','doNotMove',
      'drink','expire','facsimileTelephoneNumber','homePhone',
      'homePostalAddress','internationaliSDNNumber','janetMailbox',
      'jpegPhoto','keepNames','krbName','l','labeledURI','mail',
      'mailPreferenceOption','memberOfGroup','mobile','multiLineDescription',
      'noBatchUpdates','notRegistered','notice','onVacation',
      'organizationalStatus','otherMailbox','ou','pager','personalSignature',
      'personalTitle','photo','physicalDeliveryOfficeName','postOfficeBox',
      'postalAddress','postalCode','preferredDeliveryMethod','proxy',
      'registeredAddress','registrationStatus','roomNumber','secretary',
      'seeAlso','st','streetAddress','telephoneNumber',
      'teletexTerminalIdentifier','telexNumber','textEncodedORaddress',
      'title','uid','updateSource','userCertificate','userClass',
      'userPassword','vacationMessage','x121Address','xacl'
    ]
  },
  'nisDomainObject':{
    'requires':['nisDomain'],
    'allows':[]
  },
  'providerObject':{
    'requires':['objectClass','reciprocalNamingLink'],
    'allows':[]
  },
  'usCountyOrEquivalent':{
    'requires':['objectClass','fipsCountyNumericCode','fips55','l'],
    'allows':[
      'description','lastModifiedTime','nadfSearchGuide','searchGuide',
      'seeAlso','st','streetAddress','supplementaryInformation'
    ]
  },
  'posixGroup':{
    'requires':['cn','gidNumber'],
    'allows':['userPassword','memberUid','description']
  },
  'pilotObject':{
    'requires':['objectClass'],
    'allows':['audio','dITRedirect','info','jpegPhoto','lastModifiedBy','lastModifiedTime','manager','photo','uniqueIdentifier']
  },
  'rfc822MailGroup':{
    'requires':['objectClass','owner','cn'],
    'allows':[
      'associatedDomain',
      'autoMgt',
      'description',
      'destinationIndicator',
      'errorsTo',
      'facsimileTelephoneNumber',
      'internationaliSDNNumber',
      'joinable',
      'krbName',
      'labeledURI',
      'mail',
      'member',
      'memberOfGroup',
      'moderator',
      'multiLineDescription',
      'notice',
      'physicalDeliveryOfficeName',
      'postOfficeBox',
      'postalAddress',
      'postalCode',
      'preferredDeliveryMethod',
      'registeredAddress',
      'requestsTo',
      'rfc822ErrorsTo',
      'mail',
      'rfc822RequestsTo',
      'seeAlso',
      'streetAddress',
      'suppressNoEmailError',
      'telephoneNumber',
      'teletexTerminalIdentifier',
      'telexNumber',
      'userPassword',
      'x121Address',
      'xacl'
    ]
  },
  'nadfObject':{
    'requires':['objectClass'],
    'allows':['lastModifiedTime','nadfSearchGuide','supplementaryInformation']
  },
  'ieee802Device':{
    'requires':[],
    'allows':['macAddress']
  },
  'nadfADDMD':{
    'requires':['objectClass','ad'],
    'allows':[
      'businessCategory','description','destinationIndicator',
      'facsimileTelephoneNumber','internationaliSDNNumber','l',
      'lastModifiedTime','nadfSearchGuide','o','physicalDeliveryOfficeName',
      'postOfficeBox','postalAddress','postalCode','preferredDeliveryMethod',
      'registeredAddress','searchGuide','seeAlso','st','streetAddress',
      'supplementaryInformation','telephoneNumber','teletexTerminalIdentifier',
      'telexNumber','userPassword','x121Address'
    ]
  },
  'locality':{
    'requires':['objectClass'],
    'allows':['description','l','searchGuide','seeAlso','st','streetAddress']
  },
  'fips55Object':{
    'requires':['objectClass','fips55'],
    'allows':['st']
  },
  'eduPerson':{
    'requires':['objectClass'],
    'allows':[
      'eduPersonAffiliation',
      'eduPersonNickname',
      'eduPersonOrgDN',
      'eduPersonOrgUnitDN',
      'eduPersonPrimaryAffiliation',
      'eduPersonPrincipalName',
    ]
  },
  'inetLocalMailRecipient':{
    'requires':['objectClass'],
    'allows':['mailLocalAddress','mailHost','mailRoutingAddress']
  },
  'pkiUser':{
    'requires':['objectClass'],
    'allows':['userCertificate','userCertificate;binary']
  },
  'pkiCA':{
    'requires':['objectClass'],
    'allows':[
      'cACertificate','cACertificate;binary',
      'authorityRevocationList','authorityRevocationList;binary',
      'certificateRevocationList','certificateRevocationList;binary',
      'crossCertificatePair','crossCertificatePair;binary',
    ]
  },
  'cRLDistributionPoint':{
    'requires':['objectClass','cn'],
    'allows':[
      'authorityRevocationList','authorityRevocationList;binary',
      'certificateRevocationList','certificateRevocationList;binary',
      'deltaRevocationList','deltaRevocationList;binary',
    ]
  },
  'deltaCRL':{
    'requires':['objectClass'],
    'allows':[
      'deltaRevocationList','deltaRevocationList;binary',
    ]
  },
  'dNSZone':{
    'requires':['objectClass','zoneName','relativeDomainName'],
    'allows':[
      'dNSTTL','DNSClass',
      'aRecord','mDRecord','mXRecord','nSRecord',
      'aOARecord','cNAMERecord','pTRRecord','hInfoRecord',
      'mInfoRecord','tXTRecord','sIGRecord','kEYRecord',
      'aAAARecord','lOCRecord','nXTRecord','sRVRecord',
      'nAPTRRecord','kXRecord','cERTRecord','a6Record',
      'dNAMERecord'
    ]
  },
  'dNSDomain2':{
    'requires':['objectClass'],
    'allows':[
       'dNSTTL','dNSClass','pTRRecord','hINFORecord',
       'mINFORecord','tXTRecord','sIGRecord','kEYRecord',
       'aAAARecord','lOCRecord','nXTRecord','sRVRecord',
       'nAPTRRecord','kXRecord','cERTRecord','a6Record',
       'dNAMERecord'
    ]
  },
}
