"""
Module web2ldapcnf
(c) by Michael Stroeder, michael.stroeder@inka.de

Some variables to configure the basic behaviour of web2ldap.py
This directory should reside in /etc on Unix systems or
either %SystemRoot% or %windir% on Windows systems.
All code must be valid Python syntax.
"""

__version__ = '0.10.0'

import sys,os

# Directory where web2ldap is started
web2ldap_dir = os.path.dirname(os.path.dirname(os.path.abspath(sys.argv[0])))

# Default directory for [web2ldap]/var
var_dir = os.path.join(web2ldap_dir,'var')

# Default directory for [web2ldap]/var
etc_dir = os.path.join(web2ldap_dir,'etc')

# Default directory for [web2ldap]/var
templates_dir = os.path.join(web2ldap_dir,'templates')

# Several default sub-directories in [web2ldap]/var
for var_subdir in ['run','log','state']:
  vars()['var_'+var_subdir] = os.path.join(var_dir,var_subdir)
