#!/usr/local/bin/python -OO

"""
fcgi/web2ldap.py - stub script for running as FastCGI server

web2ldap -  web-based LDAP Client, see http://www.web2ldap.de
(c) by Michael Stroeder <michael@stroeder.com>

This software is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)
"""

import sys,os,time,fcgi,threading


exec_startdir = os.path.dirname(os.path.dirname(os.path.abspath(sys.argv[0])))
sys.path.insert(0,os.sep.join([exec_startdir,'etc','web2ldap']))
sys.path.insert(0,os.sep.join([exec_startdir,'pylib']))

if os.name == 'posix':
  # For finding web2ldapcnf.py in /etc/web2ldap on Unix systems
  sys.path.append('/etc/web2ldap')

import web2ldapcnf.misc,web2ldapcnf.fastcgi

open(web2ldapcnf.fastcgi.pid_file,'w').write(str(os.getpid()))

for i in web2ldapcnf.misc.pylibdirs:
  sys.path.insert(0,i)

import w2lapp.handler,w2lapp.core,ldapsession

def handle_request(req):
  """Function which handles a single request"""
  try:
    w2lapp.handler.HandleHTTPRequest(
      req.inp,req.out,req.err,req.env
    )
  finally:
    req.Finish()


class FastCGIThread(threading.Thread):
  """Thread class for FastCGIServer threads"""

  def __init__(self,req):
    """create a new thread to handle request in req"""
    self._req = req
    threading.Thread.__init__(self)
    self.started=time.time()
    self.setName(
      self.__class__.__name__+self.getName()[6:]
    )

  def __repr__(self):
    return '%s:%s - %s started %s' % (
      self._req.env.get('REMOTE_ADDR','unknown'),
      self._req.env.get('REMOTE_PORT','unknown'),
      self.getName(),
      time.strftime('%Y-%m-%dT%H:%M:%SZ',time.gmtime(self.started)),
    )

  def run(self):
    handle_request(self._req)


# Create instance of Thread object for cleaning-up expired sessions
cleanUpThread = w2lapp.core.CleanUpThread(
  w2lapp.core.session,interval=5
)
# Start the clean-up thread
cleanUpThread.start()

try:
  if web2ldapcnf.fastcgi.run_threaded:
    # Run multi-threaded
    while fcgi.isFCGI():
      req = fcgi.FCGI()
      t = FastCGIThread(req)
      t.start()
  else:
    # Run single-threaded
    while fcgi.isFCGI():
      req = fcgi.FCGI()
      handle_request(req)
finally:
  os.remove(web2ldapcnf.fastcgi.pid_file)
