"""
msbase.py - 
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: msbase.py,v 1.36 2001/11/23 12:41:50 michael Exp $

Compability note:
Requires Python 2.0+
"""

__version__ = '0.1.5'

import UserDict

def listremove(a,b,ignorecase=0):
  """
  Return a - b which is all elements of b removed from a

  If a,b are lists of strings then ignorecase=1 can be used.
  """
  removedict = {}
  if ignorecase:
    l = [i.lower() for i in a]
    for i in b:
      removedict[i.lower()] = 1
  else:
    l = a
    for i in b:
      removedict[i] = 1
  return [
    a[i]
    for i in range(len(l))
    if not removedict.has_key(l[i])
  ]
    
def intersection(a,b,ignorecase=0):
  """
  Return intersection of two lists a,b.
  
  If a,b are lists of strings then ignorecase=1 can be used.
  """
  temp = {}
  if ignorecase:
    for elt in a:
      temp[elt.lower()] = None
    result = [
      elt
      for elt in b
      if temp.has_key(elt.lower())
    ]
  else:
    for elt in a:
      temp[elt] = None
    result = [
      elt
      for elt in b
      if temp.has_key(elt)
    ]
  return result

def union(a,b,ignorecase=0):
  """
  Return union of two lists a,b.
  
  If a,b are lists of strings then ignorecase=1 can be used.
  """
  temp = {}
  if ignorecase:
    for elt in a:
      temp[elt.lower()] = elt
    for elt in b:
      temp[elt.lower()] = elt
  else:
    for elt in a:
      temp[elt] = elt
    for elt in b:
      temp[elt] = elt
  return [
    i[1]
    for i in temp.items()
  ]

class DefaultDict(UserDict.UserDict):
  """
  Dictionary which returns a default value for non-existent keys.
  """

  def __init__(self,default=None):
    self.__default__ = default
    UserDict.UserDict.__init__(self)

  def __getitem__(self,key):
    return self.data.get(key, self.__default__)


class GrabKeys:
  """
  Class for grabbing the string-formatting keys out of a string
  """
  def __init__(self,s):
      self.keys = []
      s % self
  def __call__(self):
    return self.keys
  def __getitem__(self, name):
      self.keys.append(name)
      return 0 # 0 is apparently compatible with all % format characters


class CaseinsensitiveStringKeyDict(UserDict.UserDict):
  """
  Dictionary class for case-insensitive string-keyed dictionaries
  """

  def __init__(self,dict={},default=None):
    UserDict.UserDict.__init__(self)
    self.__default__ = default
    self.update(dict)

  def update(self,dict):
    for key,value in dict.items():
      self.data[key.lower()] = value

  def __setitem__(self,key,value):
    self.data[key.lower()] = value

  def __getitem__(self,key):
    if self.__default__ is None:
      return self.data[key.lower()]
    else:
      return self.data.get(key.lower(), self.__default__)

  def keys(self):
    return self.data.keys()

  def has_key(self,key):
    return self.data.has_key(key.lower())

  def get(self,key,default=None):
    if default is None:
      default = self.__default__
    return self.data.get(key.lower(),default)

