"""
w2lapp.cnf.py: read configuration data

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: cnf.py,v 1.9 2002/01/08 15:06:53 michael Exp $
"""

import signal,w2lapp.core

import web2ldapcnf,web2ldapcnf.hosts,web2ldapcnf.misc,web2ldapcnf.standalone,web2ldapcnf.fastcgi
from web2ldapcnf import hosts,misc,standalone,fastcgi
from web2ldapcnf.hosts import ldap_def

def HUPSignalHandler(signum,frame):
  assert signum==signal.SIGHUP, \
    'Received wrong signal: Expected signal.SIGHUP, got %d' % (signum)
  reload(web2ldapcnf)
  reload(web2ldapcnf.hosts)
  reload(web2ldapcnf.misc)
  reload(web2ldapcnf.standalone)
  reload(web2ldapcnf.fastcgi)
  from web2ldapcnf import hosts,misc,standalone,fastcgi
  from web2ldapcnf.hosts import ldap_def
  w2lapp.core.session.expireDeactivate = w2lapp.cnf.misc.session_relogin
  w2lapp.core.session.expireRemove = w2lapp.cnf.misc.session_remove
  
# Set signal handler for SIGHUP
signal.signal(signal.SIGHUP,HUPSignalHandler)

def GetParam(ls,k='',default=''):
  """
  Get a parameter determined by string-key k
  depending on current ls.host and dn
  """
  ldap_url = ('ldap://%s/%s' % (str(ls.host),str(ls.searchRoot))).lower()
  if ldap_def.has_key(ldap_url) and ldap_def[ldap_url].__dict__.has_key(k):
    # Parameter found for LDAP URL ldap://host/current dn
    result = ldap_def[ldap_url].__dict__[k]
  elif ldap_def.has_key(ls.host) and ldap_def[ls.host].__dict__.has_key(k):
    # Parameter found for hostname
    result = ldap_def[ls.host].__dict__[k]
  elif ldap_def.has_key('_') and ldap_def['_'].__dict__.has_key(k):
    # found parameter in default section
    result = ldap_def['_'].__dict__[k]
  else:
    # no parameter found in configuration module
    result = default
  return result
