"""
w2lapp.login.py: bind with a specific bind DN and password

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: login.py,v 1.17 2002/01/10 02:27:07 michael Exp $
"""

import w2lapp.core,w2lapp.gui,w2lapp.cnf

##############################################################################
# Login form
##############################################################################

def w2l_Login(
  sid,outf,command,form,ls,dn,
  title_msg='Bind',
  login_msg='Enter complete bind DN or user name and password.',
  who='',relogin=0,nomenu=0
):
  """
  Provide a input form for doing a (re-)login
  """
  if 'login_who' in form.inputFieldNames:
    who = form.field['login_who'].value[0]

  if nomenu:
    w2lapp.gui.PrintHeader(outf,login_msg,form.accept_charset)
    w2lapp.gui.StatusLine(sid,outf,form,ls,dn)
  else:
    w2lapp.gui.TopSection(
      sid,outf,form,ls,dn,
      login_msg,
      w2lapp.gui.MainMenu(sid,form,ls,dn),
      context_menu_list=[]
    )

  outf.write("""
<div id="ErrorMessageDiv">
  <h1>%s</h1>
  <p>%s</p>
  <form
    id="CommandForm"
    action="%s/%s/%s"
    method="POST"
    enctype="application/x-www-form-urlencoded"
    accept-charset="%s"
  >
    <input type="hidden" name="host" value="%s">
    <input type="hidden" name="dn" value="%s">
    %s
"""  % (
      title_msg,
      login_msg,
      form.script_name,
      command,
      sid,
      form.accept_charset,
      ls.host.encode('ascii'),
      w2lapp.core.utf2display(form.accept_charset,dn),
      w2lapp.gui.BindInput % (
        ls.host.encode('ascii'),
        w2lapp.core.iso2display(
          form.accept_charset,
          w2lapp.cnf.hosts.ldap_def.get(ls.host,{}).get('description','')
        ),
        w2lapp.gui.SearchRootField(form,ls,dn,name='login_search_root').inputHTML(),
        who.encode(form.accept_charset),
        {0:'Login',1:'Retry'}[relogin],
      ),
    )
  )
  if relogin:
    form.hiddenInputFields(outf,['sid','host','who','cred','dn','login_search_root'])
  outf.write('</form>\n</div>')
  w2lapp.gui.PrintFooter(outf,form)

