"""
w2lapp.secinfo.py: Display (SSL) connection data

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: monitor.py,v 1.8 2002/01/10 02:27:07 michael Exp $
"""

import time,threading,utctime,w2lapp.cnf,w2lapp.core,w2lapp.gui

from pyweblib.forms import escapeHTML


def w2l_Monitor(outf,command,form):
  """
  List several general gateway stats
  """

  uptime = (time.time()-w2lapp.core.startUpTime)/60

  w2lapp.gui.PrintHeader(outf,'Gateway Monitor',form.accept_charset)

  outf.write("""
    <div id=MessageDiv>
      <h1>Gateway Monitor</h1>
      <dl>
        <dt>Current time:</dt>
        <dd>%s</dd>
        <dt>Startup time:</dt>
        <dd>%s</dd>
        <dt>Uptime:</dt>
        <dd>%s</dd>
        <dt>%d active threads:</dt>
        <dd>
          <ul>
            %s
          </ul>
        </dd>
        <dt>%d LDAP connections:</dt>
        <dd>
          <ul>
            %s
          </ul>
        </dd>
        <dt>Time until re-bind is necessary:</dt>
        <dd>%d secs</dd>
        <dt>Time after which sessions are removed:</dt>
        <dd>%d secs</dd>
      </dl>
    </div>
    """ % (
      utctime.strftimeiso8601(time.gmtime(time.time())),
      utctime.strftimeiso8601(time.gmtime(w2lapp.core.startUpTime)),
      '%02d:%02d' % (uptime/60,uptime%60),
      threading.activeCount(),
      '\n'.join(
        [
          '<li>%s</li>' % ''.join(
            [
              repr(t),
              ', alive'*t.isAlive(),
              ', daemon'*t.isDaemon(),
            ]
          )
          for t in threading.enumerate()
        ]
      ),
      len(w2lapp.core.session.sessiondict)/2,
      '\n'.join([
        '<li>%s: %s</li>' % (
          utctime.strftimeiso8601(time.gmtime(i[0])),
          escapeHTML(repr(i[1]))
        )
        for k,i in w2lapp.core.session.sessiondict.items()
        if not ((k is None) or k.startswith('__'))
      ]),
      w2lapp.core.session.expireDeactivate,
      w2lapp.core.session.expireRemove,
    )
  )
  w2lapp.gui.PrintFooter(outf,form)
