"""
w2lapp.rename.py: modify DN of an entry

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: rename.py,v 1.7 2002/01/10 02:27:07 michael Exp $
"""

import ldaputil.base,w2lapp.core,w2lapp.cnf,w2lapp.gui


def w2l_Rename(sid,outf,command,form,ls,dn):

  if not dn:
    raise w2lapp.core.ErrorExitClass(ls,dn,'Rename operation not possible at - World - or RootDSE.')
    
  if 'rename_newrdn' in form.inputFieldNames:

    rename_newrdn = form.getInputValue('rename_newrdn',[None])[0]
    rename_newsuperior = form.getInputValue('rename_newsuperior',[None])[0]
    rename_delold = form.getInputValue('rename_delold',['no'])[0]=='yes'

    # Modify the RDN
    old_dn = dn
    dn = ls.renameEntry(
      dn,rename_newrdn,rename_newsuperior,delold=rename_delold
    )
    ls.setDN(dn)

    w2lapp.gui.SimpleMessage(
      sid,outf,form,ls,dn,
      'Modified RDN of entry.',
      'Renamed entry <strong>%s</strong> to <strong>%s</strong>.' % (
        w2lapp.gui.DisplayDN(sid,form,ls,old_dn),
        w2lapp.gui.DisplayDN(sid,form,ls,dn)
      ),
      main_menu_list=w2lapp.gui.MainMenu(sid,form,ls,dn),
      context_menu_list=[]
    )

  else:
    old_rdn,old_superior = ldaputil.base.SplitRDN(dn)
    form.field['rename_newrdn'].setDefault(old_rdn)
    if ls.currentLDAPVersion>=3:
      form.field['rename_newsuperior'].setDefault(old_superior)
      new_superior_input = '<tr><td>%s</td><td>%s</td></tr>' % (
        form.field['rename_newsuperior'].text.encode(form.accept_charset),
        form.field['rename_newsuperior'].inputHTML()
      )
    else:
      if not ls.isLeafEntry(dn):
        raise w2lapp.core.ErrorExitClass(ls,dn,'Rename operation not possible with non-leaf entry.')
      new_superior_input = ''

    # Leeres Eingabeformular fr neuen RDN ausgeben
    w2lapp.gui.TopSection(
      sid,outf,form,ls,dn,
      'Rename Entry',
      w2lapp.gui.MainMenu(sid,form,ls,dn),
      context_menu_list=[]
    )
    outf.write("""
<div id="InputDiv">
<h1>Rename Entry</h1>
<form action="%s/rename/%s"
      method="POST"
      enctype="application/x-www-form-urlencoded"
      accept-charset="%s"
>
  <input type="hidden" name="dn" value="%s">
  <table>
    <tr><td>%s</td><td>%s</td></tr>
    %s
    <tr><td>%s</td><td>%s</td></tr>
  </table>
  <input type="submit" value="Change RDN">
  <input type="reset" value="Reset">
</form>
</div>
""" % (
      form.script_name,
      sid,
      form.accept_charset,
      w2lapp.core.utf2display(form.accept_charset,dn),
      form.field['rename_newrdn'].text.encode(form.accept_charset),
      form.field['rename_newrdn'].inputHTML(),
      new_superior_input,
      form.field['rename_delold'].text.encode(form.accept_charset),
      form.field['rename_delold'].inputHTML()
    ))
    w2lapp.gui.PrintFooter(outf,form)


