#!/usr/local/bin/python

import sys,string,fileinput

oc_def = {}

for s in fileinput.input():

#  sys.stderr.write(s)
  # remove comment
  pos = string.find(s,"#")
  if pos >= 0:
    s = s[ : pos]
  s = string.strip( s)
  # ignore blank line
  if not s: continue

  slist = string.split( s)
  keyword = string.lower(slist[0])

  if keyword=='objectclass':
    if len(slist)==2:
      oc = string.strip(slist[1])
      label = ''
      oc_def[oc] = {'requires':[],'allows':[]}
    elif label:
      oc_def[oc][label].append(slist[0])
  
  elif keyword=='requires' or keyword=='allows':
    label = slist[0]

  elif slist[0]:
    if slist[0][-1]==',':
      slist[0]=slist[0][:-1]
    oc_def[oc][label].append(slist[0])

outfile = sys.stdout

outfile.write('ldap_oc = {\n')

oc_list=oc_def.keys()

for oc in oc_list[:-1]:
  outfile.write("""  '%s':{
    'requires':%s,
    'allows':%s
  },
""" % (oc,oc_def[oc]['requires'],oc_def[oc]['allows']))

oc=oc_list[-1]
outfile.write("""  '%s':{
    'requires':%s,
    'allows':%s
  }
""" % (oc,oc_def[oc]['requires'],oc_def[oc]['allows']))

outfile.write('}\n')

outfile.close()
