"""
web2ldapcnf/hosts.py - Host-related options
(c) by Michael Stroeder <michael@stroeder.com>
"""

# List of all LDAP hosts to use. These hosts will appear in the
# default select list of the login form.
# A list containing only one host results in a normal input field
# with the host set as default.
ldap_host_list = [
                   'localhost',
                   'localhost:1389',
		   'ldap.itd.umich.edu',
		   'nldap.com',
		   'elvira.innosoft.com',
		   'ldap.openldap.org',
		   'ldap.baylor.edu',
		   'directory.uga.edu',
		   'ldap.surfnet.nl',
                   'ldap.tu-chemnitz.de',
		   'ldap.nameflow.net:1389',
		   'ldap-relay.directory.dfn.de:1122',
		   'db.debian.org',
		   'www.trustcenter.de',
		   'memberdir.netscape.com',
		   'directory.verisign.com',
		 ]


########################################################################
# LDAP host(s) with their defaults can be pre-defined as dictionary
# ldap_def = {'host:port':{paramdictionary}}
########################################################################


ldap_def = {

  # Overall default values.
  # There's most times no need to adjust the values in this section
  # since they can be overridden by host specific sections (see below).
  '_': {
    # Template for mapping client certs to bind DN
    'binddn':r'mail=%(Email)s',
    # Search filter template for smart login
    'binddnsearch':r'(|(cn=*%s*)(mail=%s*)(uid=%s))',
    # Timeout for synchronous LDAP operations (seconds)
    'timeout':60,
    # regular expression of subject DNs in client certs
    'sec_valid_dn':r'/.*',
    # regular expression of subject DNs in issuer certs
    'sec_valid_idn':r'/.*',
    'sec_reqlevel': 0,
    # Never show these attributes
    'hiddenattrs':['userPassword'],
    # vCard template files
    'vcard_template': {
      # 'object class':'pathname of vCard template file'
      'person':'/usr/local/web2ldap/templates/vcard_person.txt',
    },
    # HTML template files for printing table entries
    'print_template': {
      # 'object class':'pathname of printable HTML template file'
      'person':'/usr/local/web2ldap/templates/print_person.html',
      'organization':'/usr/local/web2ldap/templates/print_organization.html',
      'organizationalUnit':'/usr/local/web2ldap/templates/print_organizationalUnit.html',
    },
    # HTML template file for Basic Search form
    'searchform_template': '/usr/local/web2ldap/templates/searchform_Base.html',
    # Attributes which should be present in attribute select list of advanced search form
    'search_attrs':['cn','mail','o','ou','telephoneNumber','homePhone','description'],
    # There are some situations where this client just wants to get the
    # attributes of an entry and not the data itself for saving bandwidth.
    # However some LDAP hosts (e.g. Notes Domino 4.61) have problems with
    # such an attribute-only request, they won't return any matches for a search.
    # If you experience this problems (no matching entry) set this to 0.
    'search_attrsonly':1,
    'search_tdtemplate': {
      'inetOrgPerson':r'%(cn)s &lt;%(mail)s&gt; Tel.: %(telephoneNumber)s or %(homePhoneNumber)s',
      'organizationalUnit':r'Org. Unit &quot;%(ou)s&quot; Tel.: %(telephoneNumber)s',
      'rfc822MailGroup':r'Mailing list %(cn)s &lt;%(mail)s&gt;, see %(labeledurl)s',
      'account':r'Account <strong>%(uid)s</strong>',
    },
    'print_cols':4,
  },

  'localhost': {
    'description':'my poorly configured local LDAP host',
  },

  'localhost:1389': {
    'description':'My local OpenLDAP 2.0.x test server',
  },

  # This meant as an more complex example section
  # Adjust the settings to reflect your local LDAP installation
  'ldap://localhost/o=michaels': {
    'description':'Private address book of Michael Strder',
#    'search_tablistattrs':['cn','mail','homephone','telephonenumber'],
    'dit': {
      # 'DN':(
      #   'DN component attribute of subordinate entries',
      #   [list of objectClasses],
      #   immutable
      # )
      'o=Michaels':('ou',['organizationalUnit'],0),
      'ou=Bizness,o=Michaels':('cn',['person','organizationalPerson','inetOrgPerson'],0),
      'ou=Friends,o=Michaels':('cn',['person','organizationalPerson','inetOrgPerson'],0),
      'ou=Musicians,o=Michaels':('cn',['person','organizationalPerson','inetOrgPerson','musician'],0),
      'ou=User,o=Michaels':('uid',['account','posixAccount'],0),
      'ou=Internet Account Data,o=Michaels':('uid',['account','simpleSecurityObject'],0),
      'ou=Subscribed mailing lists,o=Michaels':('cn',['rfc822MailGroup'],0),
      'ou=web2ldap-users,ou=web2ldap,ou=Projects,o=Michaels':('mail',['person','organizationalPerson','inetOrgPerson'],0),
    },
    'read_template': {
      # 'object class':'pathname of HTML template file'
      'person':'/usr/local/web2ldap/templates/read_person.html',
      'posixAccount':'/usr/local/web2ldap/templates/read_posixAccount.html',
      'bankArrangement':'/usr/local/web2ldap/templates/read_bankArrangement.html',
      'musician':'/usr/local/web2ldap/templates/read_musician.html',
    }
  },

}

