"""
web2ldapcnf/misc.py - Misc. configuration options for web2ldap
(c) by Michael Stroeder <michael@stroeder.com>
"""

# A list with directories containing additional Python modules
pylibdirs = ['/usr/local/web2ldap/pylib']

########################################################################
# HTTP-Options
########################################################################

# UTF-8 data is printed as is and charset is set to utf-8 in HTTP header:
# 0 Never
# 1 if the browser sends utf-8 in HTTP header and the web server sets
#   HTTP_ACCEPT_CHARSET environment variable
# 2 always
print_rawutf8=1

# Body can be sent to client gzipped if client presents
# gzip in HTTP_ACCEPT_ENCODING. You can set the gzip level (1-9) here.
# Set 0 turn it off. This needs zlibmodule which is automatically detected.
# Note: This might speed things up if the server's CPU is very fast
# compared to the network link. Even with large search results you
# won't gain much by choosing gzip level higher than 1.
gzip_level=0

########################################################################
# Other Options
########################################################################

# Maximum length of LDIF data in the <TEXTAREA> of addform/modifyform
ldif_maxbytes=200000

# Maximum count of input attribute fields in addform/modifyform
input_maxattrs=200

# Maximum length of attribute data input fields in addform/modifyform
input_maxfieldlen=300

# maximum count of search parameters in advanced search form
max_searchparams=9

# Dictionary for defining user-friendly names of attributes types.
ldap_knownattr = {
  'c':'Country',
  'st':'State',
  'l':'Location',
  'o':'Organization',
  'ou':'Organizational Unit',
  'cn':'Common Name',
  'sn':'Surname',
  'givenname':'Given Name',
  'title':'Title',
  'streetaddress':'Street',
  'mail':'E-Mail',
  'uid':'User ID',
  'initials':'Initials',
  'objectclass':'Object Class',
  'telephoneNumber':'Telephone',
  'facsimileTelephoneNumber':'FAX',
  'homePhone':'Home phone',
  'description':'Description'
}

# map binary attributes to MIME-types
ldap_binaryattr = {
    'cACertificate':('CA certificate','application/x-x509-ca-cert'),
    'cACertificate;binary':('CA certificate','application/x-x509-ca-cert'),
    'authorityRevocationList':('CA CRL','application/x-pkcs7-crl'),
    'authorityRevocationList;binary':('CA CRL','application/x-pkcs7-crl'),
    'certificateRevocationList;binary':('User CRL','application/x-pkcs7-crl'),
    'certificateRevocationList':('User CRL','application/x-pkcs7-crl'),
    'certificate;binary':('Client certificate','application/x-x509-email-cert'),
    'userCertificate;binary':('Client certificate','application/x-x509-email-cert'),
    'userSMIMECertificate;binary':('S/MIME certificate','application/x-x509-email-cert'),
    'certificate':('Client certificate','application/x-x509-email-cert'),
    'entrustPolicyCertificate':('Entrust Policy Certificate','application/x-x509-email-cert'),
    'attributeCertificate':('Entrust Attribute Certificate','application/x-x509-email-cert'),
    'userCertificate':('Client certificate','application/x-x509-email-cert'),
    'pem_x509':('Client certificate','application/x-x509-email-cert'),
    'userSMIMECertificate':('S/MIME certificate','application/x-x509-email-cert'),
    'jpegPhoto':('Photograph','image/jpeg'),
    'thumbnailPhoto':('Thumbnail Photograph','image/jpeg'),
    'thumbnailLogo':('Thumbnail Logo','image/jpeg'),
    'photo':('Photograph','image/jpeg'),
    'userPKCS12;binary':('PKCS#12','application/pkcs12'),
    'audio':('Audio','audio/basic')
  }

# Some browsers are more equal than others ;-)
ldap_browsermimetypes = {
    'certificateRevocationList;binary': {
      'MSIE':'application/pkix-crl'
    },
    'certificateRevocationList': {
      'MSIE':'application/pkix-crl'
    },
  }

# Path name to dumpasn1.cfg. Grab it from
# http://www.cs.auckland.ac.nz/~pgut001/dumpasn1.cfg
dumpasn1cfg = '/etc/dumpasn1.cfg'

########################################################################
# HTML options
########################################################################

# Additional information in <HEAD></HEAD> section, e.g. CSS.
# Do not put <TITLE> tags in here!
#html_head = r"""
#  <link rel=stylesheet type="text/css" href="http://sites.inka.de/ms/css/web2ldap.css"/>
#"""
html_head = r"""
  <link rel=stylesheet type="text/css" href="/css/redandgreen.css"/>
"""

# Rudimental configuration for <body>-tag
#html_bodybegin = r"""
#<body link="Red" vlink="Maroon" bgcolor="#fffffe">
#"""
html_bodybegin = r"""
<body>
"""

########################################################################
# Security options
########################################################################

# This is the HTTP method for submitting forms
# Use POST to avoid security problems with usernames and passwords
# to be stored in URLs (-> web server logs). Also POST can
# handle more input data.
# GET is quite handy for debugging and works reliable in stand-alone mode
# on all platforms.
script_method = 'GET'

# You can set sec_expire to define the amount of
# time (in seconds) the data is valid in the browser
# (HTTP header Expires: is set).
# Note that if you're doing modifications you might get
# a very nasty behaviour if the pages are cached by your browser.
sec_expire = 3

# Specifies a list of the acceptable symmetric key ciphers to
# reach security level 1.
# See also http://www.apache-ssl.org/docs.html and the ApacheSSL
# run-time directives SSLBanCipher, SSLRequireCipher, SSLRequiredCiphers
# Does currently not affect stand-alone mode with SSL.
sec_sslacceptedciphers = [
# Strong ciphers
    'IDEA-CBC-SHA',
    'RC4-MD5',
    'RC4-SHA',
    'IDEA-CBC-MD5',
    'DES-CBC3-SHA',
    'DH-DSS-DES-CBC3-SHA',
    'DH-RSA-DES-CBC3-SHA',
    'EDH-DSS-DES-CBC3-SHA',
    'EDH-RSA-DES-CBC3-SHA',
    'ADH-RC4-MD5',
    'ADH-DES-CBC3-SHA',
    'FZA-RC4-SHA',
    'RC2-CBC-MD5',
    'DES-CBC3-MD5',
# Weak export ciphers
#    'EXP-RC4-MD5',
#    'EXP-RC2-CBC-MD5',
#    'EXP-DES-CBC-SHA',
#    'DES-CBC-SHA',
#    'EXP-DH-DSS-DES-CBC-SHA',
#    'DH-DSS-DES-CBC-SHA',
#    'EXP-DH-RSA-DES-CBC-SHA',
#    'DH-RSA-DES-CBC-SHA',
#    'EXP-EDH-DSS-DES-CBC-SHA',
#    'EDH-DSS-DES-CBC-SHA',
#    'EXP-EDH-RSA-DES-CBC',
#    'EDH-RSA-DES-CBC-SHA',
#    'EXP-ADH-RC4-MD5',
#    'EXP-ADH-DES-CBC-SHA',
#    'ADH-DES-CBC-SHA',
#    'DES-CFB-M1',
#    'DES-CBC-MD5',
#    'RC4-64-MD5'
  ]

