"""
utctime.py - various functions for parsing display UTCTime

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)
"""

import time

def strptime(s):
  """
  Parse a UTC time string.
  """
  if len(s)==15:
    # YYYYmmddHHMMSS
    year,month,day,hour,minute,second = int(s[0:4]),int(s[4:6]),int(s[6:8]),int(s[8:10]),int(s[10:12]),int(s[12:14])
  else:
    if len(s)==13:
      # YYmmddHHMMSS
      year,month,day,hour,minute,second = int(s[0:2]),int(s[2:4]),int(s[4:6]),int(s[6:8]),int(s[8:10]),int(s[10:12])
    elif len(s)==11:
      # YYmmddHHMM
      year,month,day,hour,minute,second = int(s[0:2]),int(s[2:4]),int(s[4:6]),int(s[6:8]),int(s[8:10]),0
    if year<=50:
      year=year+2000
    else:
      year=year+1900
  return (year,month,day,hour,minute,second,-1,-1,-1)


def strftimeiso8601(t):
  return time.strftime('%Y-%m-%dT%H:%M:%SZ',t)
