########################################################################
# web2ldap
# (c) by Michael Stroeder <michael@stroeder.com>
# Distributed under GNU Public License (GPL)
# web-based LDAP Client, see http://www.web2ldap.de for details
########################################################################

import sys,cgiforms, ldap, ldapbase, w2lcore, web2ldapcnf, w2lcnf, w2lgui
from ldapbase import ParentDN

########################################################################
# Delete entry
########################################################################

def w2l_Delete(outf,command,form,ls):

  if 'delete_confirm' in form.inputkeys:

    if form.field['delete_confirm'][0].content=='yes':

      # Recursive delete of whole sub-tree

      if ('delete_recursive' in form.inputkeys) and \
         form.field['delete_recursive'][0].content=='yes':

        def DelTree(outf,form,ls,ContinueErrorExit,dn,continueonerror=0):
          dellist = ldapbase.SearchTree(ls.l,dn,attrsonly=w2lcnf.GetParam(ls,'search_attrsonly',1),timeout=w2lcnf.GetParam(ls,'timeout','4'))
	  dellist.reverse()
          for dn in dellist:
            ls.l.delete_s(dn.encode('utf-8'))
   	    ls.l.uncache_entry(dn.encode('utf-8'))

        continue_on_error = ('delete_coe' in form.inputkeys) and \
                            form.field['delete_coe'][0].content=='yes'

	DelTree(outf,form,ls,continue_on_error,ls.dn,continue_on_error)
	w2lgui.PrintHeader(outf,'Delete tree',form.accept_charset)
	w2lgui.MainMenuTable(outf,form,ls,ParentDN(ls.dn))
        outf.write('<div id=MessageID><p>Deleted entries below %s.</p></div>' % (w2lgui.DisplayDN(form.accept_charset,ls.dn)))

      else:

        ls.l.delete_s(ls.dn.encode('utf-8'))
	# delete all cache entries referencing to old DN
	ls.l.uncache_entry(ls.dn.encode('utf-8'))

	w2lgui.PrintHeader(outf,'Deleted Entry',form.accept_charset)
	w2lgui.MainMenuTable(outf,form,ls,ParentDN(ls.dn))
        outf.write('<div id=MessageID><p>Deleted entry %s.</p></div>' % (w2lgui.DisplayDN(form.accept_charset,ls.dn)))

      w2lgui.PrintFooter(outf)

    else:
      raise w2lcore.ErrorExitClass(ls,'Canceled delete.')

  else:

    # Print confirmation form
    w2lgui.PrintHeader(outf,'Delete entry?',form.accept_charset)
    w2lgui.MainMenuTable(outf,form,ls)
    outf.write("""<div id=MessageDiv>
<form action="%s/delete"
      method="%s"
      enctype="application/x-www-form-urlencoded"
      accept-charset="%s"
>
  <input type=hidden name="dn" value="%s">
  <input type=hidden name="host" value="%s">
  <input type=hidden name="who" value="%s">
  <input type=hidden name="cred" value="%s">
  <p>Delete %s. Are you sure?</p>
  <p>
    %s Recursive delete of all sub-entries.
    <strong>Use with care! Might take some time.</strong><br>
    %s Continue on error (affects only recursive delete).
  </p>
  <input name="delete_confirm" type="submit" value="yes">
  <input name="delete_confirm" type="submit" value="no">
</form>
</div>
""" % (
      form.script_name,
      web2ldapcnf.script_method,
      form.accept_charset,
      w2lcore.utf2display(form.accept_charset,ls.dn),
      ls.host.encode(form.accept_charset),
      w2lcore.utf2display(form.accept_charset,ls.who),
      w2lcore.utf2display(form.accept_charset,ls.cred),
      w2lgui.DisplayDN(form.accept_charset,ls.dn),
      form.field['delete_recursive'][0].inputfield(),
      form.field['delete_coe'][0].inputfield()
    ))
    w2lgui.PrintFooter(outf)

