#!/usr/local/bin/python2.0

########################################################################
# web2ldap -  web-based LDAP Client, see http://www.web2ldap.de
# (c) by Michael Stroeder <michael@stroeder.com>
########################################################################
# This software is distributed under the terms of the
# GPL (GNU GENERAL PUBLIC LICENSE) Version 2
# (see http://www.gnu.org/copyleft/gpl.html)
########################################################################

import sys,os,string

if os.name == 'posix':
  # For finding web2ldapcnf.py in /etc/web2ldap on Unix systems
  sys.path.insert(0,'/usr/local/web2ldap/etc/web2ldap')
else:
  # For finding web2ldapcnf.py in system dirs on Windows systems
  for i in ['SystemRoot','windir']:
    if os.environ.has_key(i):
      sys.path.insert(0,os.environ[i])

exec_startdir = os.path.dirname(os.path.dirname(os.path.abspath(sys.argv[0])))
sys.path.extend(
  [
    string.join([exec_startdir,'etc','web2ldap'],os.sep),
    string.join([exec_startdir,'pylib'],os.sep)
  ]
)

import web2ldapcnf
for i in web2ldapcnf.pylibdirs:
  sys.path.insert(0,i)

import w2lcore,w2lhandler,msHTTPServer

server_software = 'webldap %s' % w2lcore.Version
server_env = {}
server_env['SERVER_SOFTWARE'] = server_software
server_env['SERVER_ADMIN'] = web2ldapcnf.server_admin
server_env['DOCUMENT_ROOT'] = web2ldapcnf.document_root
server_env['SERVER_SIGNATURE'] = web2ldapcnf.server_signature

class web2ldapHTTPHandlerClass(msHTTPServer.HTTPHandlerClass):

  # Start web2ldap itself.
  def run_app(self,http_env):
    msHTTPServer.HTTPHandlerClass.run_app(self,http_env)
    # Call application handler function
    w2lhandler.HandleHTTPRequest(self.rfile,self.wfile,http_env)
    return

web2ldapHTTPHandler = web2ldapHTTPHandlerClass

msHTTPServer.ServerStartup(
  web2ldapHTTPHandler,
  server_env,
  '/web2ldap',
  ['127.0.0.1',1760],
  server_software,
  os.name == 'posix',
#  web2ldapcnf.standalone.run_threaded=='on',
  0,
  web2ldapcnf.standalone.ssl_Engine=='on',
  web2ldapcnf.standalone.run_username,
  web2ldapcnf.standalone.document_root,
  web2ldapcnf.standalone.access_allowed,
  web2ldapcnf.standalone.access_log,
  web2ldapcnf.standalone.error_log,
  web2ldapcnf.standalone.debug_log,
  web2ldapcnf.standalone.mime_types,
  web2ldapcnf.standalone.ssl_randfile,
  web2ldapcnf.standalone.ssl_Protocols,
  web2ldapcnf.standalone.ssl_CertificateFile,
  web2ldapcnf.standalone.ssl_CertificateKeyFile,
  web2ldapcnf.standalone.ssl_CACertificateFile,
  web2ldapcnf.standalone.ssl_VerifyClient,
  web2ldapcnf.standalone.ssl_VerifyDepth,
)

sys.exit(0)
