"""
entrustext.py - classes for X.509v3 extensions specified by Entrust
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

Unlike other extension classes where the ASN.1 type names are used
as class names we use the OpenSSL names as class names.

"""


# Python standard lib
import sys, string
# Pisces
from pisces import asn1
# mspki itself
import x509v3, asn1helper


class entrustVersInfo(x509v3.ExtnValue,asn1.OctetString):
  """
  entrustVersInfo EXTENSION ::= {
          SYNTAX EntrustVersInfoSyntax
          IDENTIFIED BY { id-nsn-ext 0}
  }

  EntrustVersInfoSyntax ::= OCTET STRING
  """
  def __init__(self,val):
    asn1.OctetString.__init__(self,val)
    self.val = val

  def __str__(self):
    return str(self.val[0])+repr(self.val[1])


