########################################################################
# web2ldap
# (c) by Michael Stroeder <michael@stroeder.com>
# Distributed under GNU Public License (GPL)
# web-based LDAP Client, see http://www.web2ldap.de for details
########################################################################

import string

from web2ldapcnf import ldap_def

def GetParam(ls,k='',default=''):
  """
  Get a parameter determined by string-key k
  depending on current ls.host and ls.dn
  """
  ldap_url = string.lower('ldap://%s/%s' % (ls.host,ls.dn))
  if ldap_def.has_key(ldap_url) and ldap_def[ldap_url].has_key(k):
    # Parameter found for LDAP URL ldap://host/current dn
    return ldap_def[ldap_url][k]
  elif ldap_def.has_key(ls.host) and ldap_def[ls.host].has_key(k):
    # Parameter found for hostname
    return ldap_def[ls.host][k]
  elif ldap_def.has_key('_') and ldap_def['_'].has_key(k):
    # found parameter in default section
    return ldap_def['_'][k]
  else:
    # no parameter found in configuration module
    return default
