########################################################################
# web2ldap
# (c) by Michael Stroeder <michael@stroeder.com>
# Distributed under GNU Public License (GPL)
# web-based LDAP Client, see http://www.web2ldap.de for details
########################################################################

import sys,string,web2ldapcnf

# Modules shipped with web2ldap
import cgiforms,cgiforms,w2lcore,w2lgui

##############################################################################
# Connect form
##############################################################################

def w2l_Connect(outf,command,form,ls):

  w2lgui.PrintHeader(outf,'Connect',form.accept_charset)

  host_select_list = []
  for host in web2ldapcnf.ldap_host_list:
    host_desc = web2ldapcnf.hosts.ldap_def.get(host,{}).get('description','')
    if host_desc:
      host_str = '%s (%s)' % (host,host_desc)
    else:
      host_str = host
    host_select_list.append(
      (
	unicode(host,'iso-8859-1'),
	unicode(host_str,'iso-8859-1')
      )
    )
  host_select_field = cgiforms.formSelectClass('host',u'LDAP Host',host_select_list,default=ls.host)

  outf.write("""
<div id=inputdiv>
  <fieldset title="Pre-selected LDAP hosts">
    <form 
      action="%s/bind"
      method="%s" 
      enctype="application/x-www-form-urlencoded"
      accept-charset="%s"
    >
      <h1>Pre-configured LDAP host(s)</h1>
      Choose a LDAP server from select list
      <p><input type=submit value="Connect to">%s</p>
      <input type="hidden" name="dn" value="">
    </form>
  </fieldset>
</div>

<div id=inputdiv>
  <fieldset title="Any LDAP host by name:port">
    <form 
      action="%s/bind"
      method="%s" 
      enctype="application/x-www-form-urlencoded"
      accept-charset="%s"
    >
      <h1>Any LDAP host</h1>
      Input host:port of LDAP server.
      <p><input type=submit value="Connect to">%s</p>
      <input type="hidden" name="dn" value="">
    </form>
  </fieldset>
</div>
""" % (
    form.script_name,
    web2ldapcnf.script_method,
    form.accept_charset,
    host_select_field.inputfield(),
    form.script_name,
    web2ldapcnf.script_method,
    form.accept_charset,
    form.field['host'][0].inputfield()
  )
)

  w2lgui.PrintFooter(outf)
