
require 'bind8-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the bind8 module
sub acl_security_form
{
local $m = $_[0]->{'zones'} eq '*' ? 1 :
	   $_[0]->{'zones'} =~ /^\!/ ? 2 : 0;
print "<tr> <td valign=top><b>$text{'acl_zones'}</b></td>\n";
print "<td colspan=3><table cellpadding=0 cellspacing=0> <tr><td valign=top>\n";
printf "<input type=radio name=zones_def value=1 %s> %s<br>\n",
	$m == 1 ? 'checked' : '', $text{'acl_zall'};
printf "<input type=radio name=zones_def value=0 %s> %s<br>\n",
	$m == 0 ? 'checked' : '', $text{'acl_zsel'};
printf "<input type=radio name=zones_def value=2 %s> %s</td>\n",
	$m == 2 ? 'checked' : '', $text{'acl_znsel'};

print "<td><select name=zones multiple size=4 width=150>\n";
local $conf = &get_config();
local @zones = grep { $_->{'value'} ne "." }
		    &find("zone", $conf);
local $v;
foreach $v (&find("view", $conf)) {
	push(@zones, grep { $_->{'value'} ne "." }
			  &find("zone", $v->{'members'}));
	}
local ($z, %zcan);
map { $zcan{$_}++ } split(/\s+/, $_[0]->{'zones'});
foreach $z (sort { $a->{'value'} cmp $b->{'value'} } @zones) {
	printf "<option value='%s' %s>%s\n",
		$z->{'value'},
		$zcan{$z->{'value'}} ? "selected" : "",
		&arpa_to_ip($z->{'value'});
	}
print "</select></td> </tr></table></td></tr>\n";

print "<tr> <td valign=top><b>$text{'acl_dir'}</b></td>\n";
printf "<td colspan=3><input name=dir size=30 value='%s'> %s<br>\n",
	$_[0]->{'dir'}, &file_chooser_button("dir", 1);
printf "<input type=checkbox name=dironly value=1 %s> %s</td> </tr>\n",
	$_[0]->{'dironly'} ? "checked" : "", $text{'acl_dironly'};

print "<tr> <td><b>$text{'acl_master'}</b></td> <td>\n";
printf "<input type=radio name=master value=1 %s> $text{'yes'}\n",
	$_[0]->{'master'} ? "checked" : "";
printf "<input type=radio name=master value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'master'} ? "" : "checked";

print "<td><b>$text{'acl_slave'}</b></td> <td>\n";
printf "<input type=radio name=slave value=1 %s> $text{'yes'}\n",
	$_[0]->{'slave'} ? "checked" : "";
printf "<input type=radio name=slave value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'slave'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_forward'}</b></td> <td>\n";
printf "<input type=radio name=forward value=1 %s> $text{'yes'}\n",
	$_[0]->{'forward'} ? "checked" : "";
printf "<input type=radio name=forward value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'forward'} ? "" : "checked";

print "<td><b>$text{'acl_defaults'}</b></td> <td>\n";
printf "<input type=radio name=defaults value=1 %s> $text{'yes'}\n",
	$_[0]->{'defaults'} ? "checked" : "";
printf "<input type=radio name=defaults value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'defaults'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_reverse'}</b></td> <td>\n";
printf "<input type=radio name=reverse value=1 %s> $text{'yes'}\n",
	$_[0]->{'reverse'} ? "checked" : "";
printf "<input type=radio name=reverse value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'reverse'} ? "" : "checked";

print "<td><b>$text{'acl_multiple'}</b></td> <td>\n";
printf "<input type=radio name=multiple value=1 %s> $text{'yes'}\n",
	$_[0]->{'multiple'} ? "checked" : "";
printf "<input type=radio name=multiple value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'multiple'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_ro'}</b></td> <td>\n";
printf "<input type=radio name=ro value=1 %s> $text{'yes'}\n",
	$_[0]->{'ro'} ? "checked" : "";
printf "<input type=radio name=ro value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'ro'} ? "" : "checked";

print "<td><b>$text{'acl_apply'}</b></td> <td>\n";
printf "<input type=radio name=apply value=1 %s> $text{'yes'}\n",
	$_[0]->{'apply'} ? "checked" : "";
printf "<input type=radio name=apply value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'apply'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_file'}</b></td> <td>\n";
printf "<input type=radio name=file value=1 %s> $text{'yes'}\n",
	$_[0]->{'file'} ? "checked" : "";
printf "<input type=radio name=file value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'file'} ? "" : "checked";

print "<td><b>$text{'acl_params'}</b></td> <td>\n";
printf "<input type=radio name=params value=1 %s> $text{'yes'}\n",
	$_[0]->{'params'} ? "checked" : "";
printf "<input type=radio name=params value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'params'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_opts'}</b></td> <td>\n";
printf "<input type=radio name=opts value=1 %s> $text{'yes'}\n",
	$_[0]->{'opts'} ? "checked" : "";
printf "<input type=radio name=opts value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'opts'} ? "" : "checked";

print "<td><b>$text{'acl_delete'}</b></td> <td>\n";
printf "<input type=radio name=delete value=1 %s> $text{'yes'}\n",
	$_[0]->{'delete'} ? "checked" : "";
printf "<input type=radio name=delete value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'delete'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_gen'}</b></td> <td>\n";
printf "<input type=radio name=gen value=1 %s> $text{'yes'}\n",
	$_[0]->{'gen'} ? "checked" : "";
printf "<input type=radio name=gen value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'gen'} ? "" : "checked";

print "<td><b>$text{'acl_whois'}</b></td> <td>\n";
printf "<input type=radio name=whois value=1 %s> $text{'yes'}\n",
	$_[0]->{'whois'} ? "checked" : "";
printf "<input type=radio name=whois value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'whois'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_findfree'}</b></td> <td>\n";
printf "<input type=radio name=findfree value=1 %s> $text{'yes'}\n",
	$_[0]->{'findfree'} ? "checked" : "";
printf "<input type=radio name=findfree value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'findfree'} ? "" : "checked";

print "<td><b>$text{'acl_views'}</b></td> <td>\n";
printf "<input type=radio name=views value=1 %s> $text{'yes'}\n",
	$_[0]->{'views'} ? "checked" : "";
printf "<input type=radio name=views value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'views'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_remote'}</b></td> <td>\n";
printf "<input type=radio name=remote value=1 %s> $text{'yes'}\n",
	$_[0]->{'remote'} ? "checked" : "";
printf "<input type=radio name=remote value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'remote'} ? "" : "checked";
}

# acl_security_save(&options)
# Parse the form for security options for the bind8 module
sub acl_security_save
{
if ($in{'zones_def'} == 1) {
	$_[0]->{'zones'} = "*";
	}
elsif ($in{'zones_def'} == 2) {
	$_[0]->{'zones'} = join(" ", "!", split(/\0/, $in{'zones'}));
	}
else {
	$_[0]->{'zones'} = join(" ", split(/\0/, $in{'zones'}));
	}
$_[0]->{'master'} = $in{'master'};
$_[0]->{'slave'} = $in{'slave'};
$_[0]->{'forward'} = $in{'forward'};
$_[0]->{'defaults'} = $in{'defaults'};
$_[0]->{'reverse'} = $in{'reverse'};
$_[0]->{'multiple'} = $in{'multiple'};
$_[0]->{'ro'} = $in{'ro'};
$_[0]->{'apply'} = $in{'apply'};
$_[0]->{'dir'} = $in{'dir'};
$_[0]->{'dironly'} = $in{'dironly'};
$_[0]->{'file'} = $in{'file'};
$_[0]->{'params'} = $in{'params'};
$_[0]->{'opts'} = $in{'opts'};
$_[0]->{'delete'} = $in{'delete'};
$_[0]->{'findfree'} = $in{'findfree'};
$_[0]->{'views'} = $in{'views'};
$_[0]->{'remote'} = $in{'remote'};
$_[0]->{'gen'} = $in{'gen'};
$_[0]->{'whois'} = $in{'whois'};
}

