#!/usr/local/bin/perl
# edit_soa.cgi
# Display the SOA for an existing master zone

require './bind8-lib.pl';
&ReadParse();
$conf = &get_config();
if ($in{'view'}) {
	$conf = $conf->[$in{'view'}]->{'members'};
	}
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $conf->[$in{'index'}]) ||
	&error($text{'master_ecannot'});
$access{'params'} || &error($text{'master_esoacannot'});
&header($text{'master_params'}, "");
print "<center><font size=+2>", &ip6int_to_net(&arpa_to_ip($dom)),
      "</font></center>\n";

@recs = &read_zone_file(&find("file", $zconf)->{'value'}, $dom);
foreach $r (@recs) {
	$soa = $r if ($r->{'type'} eq "SOA");
	}
$v = $soa->{'values'};

# form for editing SOA record
print "<hr>\n";
print "<form action=save_soa.cgi>\n";
print "<input type=hidden name=file value=\"$soa->{'file'}\">\n";
print "<input type=hidden name=num value=\"$soa->{'num'}\">\n";
print "<input type=hidden name=origin value=\"$dom\">\n";
print "<input type=hidden name=index value=\"$in{'index'}\">\n";
print "<input type=hidden name=view value=\"$in{'view'}\">\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'master_params'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'master_server'}</b></td>\n";
print "<td><input name=master size=20 value=\"$v->[0]\"></td>\n";
$v->[1] = &dotted_to_email($v->[1]);
print "<td><b>$text{'master_email'}</b></td>\n";
print "<td><input name=email size=20 value=\"$v->[1]\"></td> </tr>\n";

@u = &extract_time_units($v->[3], $v->[4], $v->[5], $v->[6]);
print "<tr> <td><b>$text{'master_refresh'}</b></td>\n";
print "<td><input name=refresh size=10 value=\"$v->[3]\">\n";
&time_unit_choice("refunit", $u[0]);
print "</td>\n";
print "<td><b>$text{'master_retry'}</b></td>\n";
print "<td><input name=retry size=10 value=\"$v->[4]\">\n";
&time_unit_choice("retunit", $u[1]);
print "</td> </tr>\n";

print "<tr> <td><b>$text{'master_expiry'}</b></td>\n";
print "<td><input name=expiry size=10 value=\"$v->[5]\">\n";
&time_unit_choice("expunit", $u[2]);
print "</td>\n";
print "<td><b>$text{'master_minimum'}</b></td>\n";
print "<td><input name=minimum size=10 value=\"$v->[6]\">\n";
&time_unit_choice("minunit", $u[3]);
print "</td> </tr>\n";

if (!$config{'updserial_on'}) {
	print "<tr> <td><b>$text{'master_serial'}</b></td>\n";
	print "<td><input name=serial size=20 value=\"$v->[2]\"></td> </tr>\n";
	}

print "</table></td></tr> </table><br>\n";
print "<input type=submit value=\"$text{'save'}\">\n" if (!$access{'ro'});
print "</form><p>\n";

print "<hr>\n";
&footer("edit_master.cgi?index=$in{'index'}&view=$in{'view'}",
	$text{'master_return'});

