# cluster-webmin-lib.pl
# Common functions for managing webmin installs across a cluster

do '../web-lib.pl';
&init_config();
&foreign_require("servers", "servers-lib.pl");

# list_webmin_hosts()
# Returns a list of all hosts whose webmin modules are being managed
sub list_webmin_hosts
{
local $hdir = "$module_config_directory/hosts";
opendir(DIR, $hdir);
foreach $h (readdir(DIR)) {
	next if ($h eq "." || $h eq ".." || !-d "$hdir/$h");
	local %host = ( 'id', $h );
	local $f;
	opendir(MDIR, "$hdir/$h");
	foreach $f (readdir(MDIR)) {
		if ($f =~ /^(\S+)\.mod$/) {
			local %mod;
			&read_file("$hdir/$h/$f", \%mod);
			push(@{$host{'modules'}}, \%mod);
			}
		elsif ($f =~ /^(\S+)\.theme$/) {
			local %theme;
			&read_file("$hdir/$h/$f", \%theme);
			push(@{$host{'themes'}}, \%theme);
			}
		elsif ($f =~ /^(\S+)\.user$/) {
			local %user;
			&read_file("$hdir/$h/$f", \%user);
			$user{'modules'} = [ split(/\s+/, $user{'modules'}) ];
			$user{'ownmods'} = [ split(/\s+/, $user{'ownmods'}) ];
			push(@{$host{'users'}}, \%user);
			}
		elsif ($f =~ /^(\S+)\.group$/) {
			local %group;
			&read_file("$hdir/$h/$f", \%group);
			$group{'modules'} = [ split(/\s+/, $group{'modules'}) ];
			$group{'ownmods'} = [ split(/\s+/, $group{'ownmods'}) ];
			$group{'members'} = [ split(/\s+/, $group{'members'}) ];
			push(@{$host{'groups'}}, \%group);
			}
		elsif ($f eq "webmin") {
			&read_file("$hdir/$h/$f", \%host);
			}
		}
	closedir(MDIR);
	push(@rv, \%host);
	}
closedir(DIR);
return @rv;
}

# save_webmin_host(&host)
sub save_webmin_host
{
local $hdir = "$module_config_directory/hosts";
local %oldfile;
mkdir($hdir, 0700);
if (-d "$hdir/$_[0]->{'id'}") {
	opendir(DIR, "$hdir/$_[0]->{'id'}");
	map { $oldfile{$_}++ } readdir(DIR);
	closedir(DIR);
	}
else {
	mkdir("$hdir/$_[0]->{'id'}", 0700);
	}
local $m;
foreach $m (@{$_[0]->{'modules'}}) {
	&write_file("$hdir/$_[0]->{'id'}/$m->{'dir'}.mod", $m);
	delete($oldfile{"$m->{'dir'}.mod"});
	}
foreach $m (@{$_[0]->{'themes'}}) {
	&write_file("$hdir/$_[0]->{'id'}/$m->{'dir'}.theme", $m);
	delete($oldfile{"$m->{'dir'}.theme"});
	}
foreach $m (@{$_[0]->{'users'}}) {
	local %u = %$m;
	$u{'modules'} = join(" ", @{$u{'modules'}});
	$u{'ownmods'} = join(" ", @{$u{'ownmods'}});
	&write_file("$hdir/$_[0]->{'id'}/$u{'name'}.user", \%u);
	delete($oldfile{"$u{'name'}.user"});
	}
foreach $m (@{$_[0]->{'groups'}}) {
	local %g = %$m;
	$g{'modules'} = join(" ", @{$g{'modules'}});
	$g{'ownmods'} = join(" ", @{$g{'ownmods'}});
	$g{'members'} = join(" ", @{$g{'members'}});
	&write_file("$hdir/$_[0]->{'id'}/$g{'name'}.group", \%g);
	delete($oldfile{"$g{'name'}.group"});
	}
local %webmin = %{$_[0]};
delete($webmin{'modules'});
delete($webmin{'themes'});
delete($webmin{'users'});
delete($webmin{'groups'});
delete($webmin{'id'});
&write_file("$hdir/$_[0]->{'id'}/webmin", \%webmin);
delete($oldfile{"webmin"});
unlink(map { "$hdir/$_[0]->{'id'}/$_" } keys %oldfile);
}

# delete_webmin_host(&host)
sub delete_webmin_host
{
system("rm -rf '$module_config_directory/hosts/$_[0]->{'id'}'");
}

# list_servers()
# Returns a list of all servers from the webmin servers module that can be
# managed, plus this server
sub list_servers
{
local @servers = &foreign_call("servers", "list_servers");
return ( { 'id' => 0, 'desc' => $text{'this_server'}, 'type' => 'unknown' },
	 grep { $_->{'user'} } @servers );
}

# server_name(&server)
sub server_name
{
return $_[0]->{'desc'} ? $_[0]->{'desc'} : $_[0]->{'host'};
}

# all_modules(&hosts)
sub all_modules
{
local (%done, $u, %descc);
local @uniq = grep { !$done{$_->{'dir'}}++ } map { @{$_->{'modules'}} } @{$_[0]};
map { $descc{$_->{'desc'}}++ } @uniq;
foreach $u (@uniq) {
	$u->{'desc'} .= " ($u->{'dir'})" if ($descc{$u->{'desc'}} > 1);
	}
return sort { $a->{'desc'} cmp $b->{'desc'} } @uniq;
}

# all_themes(&hosts)
sub all_themes
{
local %done;
return sort { $a->{'desc'} cmp $b->{'desc'} }
	grep { !$done{$_->{'dir'}}++ }
	 map { @{$_->{'themes'}} } @{$_[0]};
}

# all_groups(&hosts)
sub all_groups
{
local %done;
return sort { $a->{'name'} cmp $b->{'name'} }
	grep { !$done{$_->{'name'}}++ }
	 map { @{$_->{'groups'}} } @{$_[0]};
}

# all_users(&hosts)
sub all_users
{
local %done;
return sort { $a->{'name'} cmp $b->{'name'} }
	grep { !$done{$_->{'name'}}++ }
	 map { @{$_->{'users'}} } @{$_[0]};
}

1;

