# cpan-lib.pl
# Functions for getting information about perl modules

do '../web-lib.pl';
&init_config();
use Config;
$packages_file = "$module_config_directory/packages.txt.gz";

# Get the paths to perl and perldoc
open(PERL, "$config_directory/perl-path");
chop($perl_path = <PERL>);
close(PERL);
if (&has_command("perldoc")) {
	$perl_doc = &has_command("perldoc");
	}
else {
	$perl_path =~ /^(.*)\/[^\/]+$/;
	if (-x "$1/perldoc") {
		$perl_doc = "$1/perldoc";
		}
	}
if ($perl_doc && $] >= 5.006) {
	$perl_doc = "$perl_path -T $perl_doc";
	}

# list_perl_modules()
# Returns a list of all installed perl modules, but reading .packlist files
sub list_perl_modules
{
local (@rv, %done, $d);
foreach $d ($Config{'privlib'}, $Config{'sitelib_stem'} ?
				$Config{'sitelib_stem'} : $Config{'sitelib'}) {
	local $f;
	open(FIND, "find '$d' -name .packlist -print |");
	while($f = <FIND>) {
		chop($f);
		next if ($done{$f}++);
		local @st = stat($f);
		local $mod = { 'date' => scalar(localtime($st[9])),
			       'packfile' => $f,
			       'index' => scalar(@rv) };
		$f =~ /\/(([A-Z][^\/]*\/)*[^\/]+)\/.packlist$/;
		$mod->{'name'} = $1;
		$mod->{'name'} =~ s/\//::/g;
		local (%donefile, $l);
		open(FILE, $f);
		while($l = <FILE>) {
			chop($l);
			$l =~ s/^\/tmp\/[^\/]+//;
			$l =~ s/^\/var\/tmp\/[^\/]+//;
			next if ($donefile{$l}++);
			if ($l =~ /\/((([A-Z][^\/]*\/)([^\/]+\/)?)?[^\/]+)\.pm$/) {
				local $mn = $1;
				$mn =~ s/\//::/g;
				push(@{$mod->{'mods'}}, $mn);
				push(@{$mod->{'files'}}, $l);
				}
			elsif ($l =~ /^([^\/]+)\.pm$/) {
				# Module name only, with no path! Damn redhat..
				local @rpath;
				open(FIND2, "find '$d' -name '$l' -print |");
				while(<FIND2>) {
					chop;
					push(@rpath, $_);
					}
				close(FIND2);
				@rpath = sort { length($a) cmp length($b) } @rpath;
				if (@rpath) {
					$rpath[0] =~ /\/(([A-Z][^\/]*\/)*[^\/]+)\.pm$/;
					local $mn = $1;
					$mn =~ s/\//::/g;
					push(@{$mod->{'mods'}}, $mn);
					push(@{$mod->{'files'}}, $rpath[0]);
					$mod->{'noremove'} = 1;
					}
				}
			push(@{$mod->{'packlist'}}, $l);
			}
		close(FILE);
		local $mi = &indexof($mod->{'name'}, @{$mod->{'mods'}});
		$mod->{'master'} = $mi < 0 ? 0 : $mi;
		push(@rv, $mod) if (@{$mod->{'mods'}});
		}
	close(FIND);
	}
return @rv;
}

# module_desc(&mod, index)
# Returns a one-line description for some module
sub module_desc
{
local ($in_name, $desc);
local $f = $_[0]->{'files'}->[$_[1]];
local $pf = $f;
$pf =~ s/\.pm$/\.pod/;
open(MOD, $pf) || open(MOD, $f);
while(<MOD>) {
	if (/^=head1\s+name/i) {
		$in_name = 1;
		}
	elsif (/^=/ && $in_name) {
		last;
		}
	elsif ($in_name) {
		$desc .= $_;
		}
	}
close(MOD);
local $name = $_[0]->{'mods'}->[$_[1]];
$desc =~ s/^\s*$name\s+\-\s+// ||
	$desc =~ s/^\s*\S*<$name>\s+\-\s+//;
$desc =~ s/\$Id:.*\$//;
return $desc;
}

# download_packages_file(&callback)
sub download_packages_file
{
$config{'packages'} =~ /^http:\/\/([^\/]+)(\/.*)$/ ||
	&error($text{'download_epackages'});
local ($host, $page, $port) = ($1, $2, 80);
if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
&http_download($host, $port, $page, $packages_file, undef, $_[0]);
}

1;

