#!/usr/local/bin/perl
# index.cgi
# Display a list of known disks and partitions

require './fdisk-lib.pl';
&error_setup($text{'index_err'});
&check_fdisk();
&header($text{'index_title'}, "", undef, 0, 1, 0,
	&help_search_link("fdisk", "man", "doc", "howto"));
print "<hr>\n";
$extwidth = 250;

&read_acl(\%acl);
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_disk'}</b></td> ",
      "<td><b>$text{'index_parts'}</b></td> </tr>\n";
foreach $d (&list_disks_partitions()) {
	local $ed = &can_edit_disk($d->{'device'});
	next if (!$ed && !$access{'view'});
	print "<tr $cb> <td valign=top><table>\n";
	print "<tr> <td><b>$text{'index_location'}</b></td> ";
	print "<td>$d->{'desc'}</td>\n";
	print "<tr> <td><b>$text{'index_cylinders'}</b></td> ",
	      "<td>$d->{'cylinders'}</td> </tr>\n";
	if ($d->{'model'}) {
		print "<tr> <td><b>$text{'index_model'}</b></td> ",
		      "<td>$d->{'model'}</td> </tr>\n";
		}
	if (defined($d->{'scsiid'}) && defined($d->{'controller'})) {
		print "<tr> <td><b>$text{'index_controller'}</b></td> ",
		      "<td>$d->{'controller'}</td> </tr>\n";
		print "<tr> <td><b>$text{'index_scsiid'}</b></td> ",
		      "<td>$d->{'scsiid'}</td> </tr>\n";
		}
	if ($d->{'raid'}) {
		print "<tr> <td><b>$text{'index_raid'}</b></td> ",
		      "<td>$d->{'raid'}</td> </tr>\n";
		}
	if ($d->{'type'} eq 'ide' && $ed) {
		# Display link to IDE params form
		print "<tr> <td colspan=2><a href='edit_hdparm.cgi?disk=",
		      $d->{'index'},"'>$text{'index_hdparm'}</a></td> </tr>\n";
		}
	print "</table></td> <td valign=top>\n";

	@parts = @{$d->{'parts'}};
	foreach $p (@parts) {
		if ($p->{'end'} > $d->{'cylinders'}-1) {
			$d->{'cylinders'} = $p->{'end'}+1;
			}
		}
	local $extended = 0;
	local $usedpri = 0;
	if (!@parts) {
		print "<b>$text{'index_none'}</b><p>\n";
		}
	else {
		print "<table width=100%> ",
		      "<tr> <td><b>$text{'index_num'}</b></td> ",
		      "<td><b>$text{'index_type'}</b></td> ",
                      "<td><b>$text{'index_extent'}</b></td> ",
                      "<td><b>$text{'index_start'}</b></td> ",
                      "<td><b>$text{'index_end'}</b></td> ",
                      "<td><b>$text{'index_use'}</b></td> ",
                      "<td><b>$text{'index_free'}</b></td> </tr>\n";
		foreach $p (@parts) {
			if (!$ed) {
				print "<tr> <td>$p->{'number'}</td>\n";
				}
			elsif ($p->{'extended'}) {
				print "<tr> <td><a href=\"edit_part.cgi?",
				      "disk=$d->{'index'}&part=$p->{'index'}\">",
				      "$p->{'number'}</a></td>\n";
				$extended++;
				}
			else {
				print "<tr> <td><a href=\"edit_part.cgi?",
				      "disk=$d->{'index'}&part=$p->{'index'}\">",
				      "$p->{'number'}</a></td>\n";
				}
			$usedpri++ if ($p->{'number'} <= 4);
			print "<td>",$p->{'extended'} ? $text{'extended'}
						      : &tag_name($p->{'type'}),
			      "</td> <td>\n";
			printf "<img src=images/gap.gif height=10 width=%d>",
				$extwidth*($p->{'start'} - 1) /
				$d->{'cylinders'};
			printf "<img src=images/%s.gif height=10 width=%d>",
				$p->{'extended'} ? "ext" : "use",
				$extwidth*($p->{'end'} - $p->{'start'}) /
				$d->{'cylinders'};
			printf "<img src=images/gap.gif height=10 width=%d>",
			  $extwidth*($d->{'cylinders'} - ($p->{'end'} - 1)) /
				    $d->{'cylinders'};
			print "</td> <td>$p->{'start'}</td> ",
			      "<td>$p->{'end'}</td> <td>\n";
			@stat = &device_status($p->{'device'});
			if ($stat[1] eq 'raid') {
				print "<tt>$stat[0]</tt>\n";
				}
			elsif ($stat[1] eq 'lvm') {
				if ($acl{$base_remote_user,'lvm'}) {
					print "<tt><a href='/lvm/'>VG $stat[0]</a></tt>\n";
					}
				else {
					print "<tt>VG $stat[0]</tt>\n";
					}
				}
			elsif ($stat[0] && !$acl{$base_remote_user,'mount'}) {
				print "<tt>$stat[0]</tt>\n";
				}
			elsif ($stat[0] && $stat[3] == -1) {
				print "<tt><a href='/mount/edit_mount.cgi?index=$stat[4]&temp=1&return=/$module_name/'>$stat[0]</a></tt>\n";
				}
			elsif ($stat[0]) {
				print "<tt><a href='/mount/edit_mount.cgi?index=$stat[3]&return=/$module_name/'>$stat[0]</a></tt>\n";
				}
			print "</td> <td>\n";
			if (!$p->{'extended'} && $stat[2] &&
			    &indexof($p->{'type'}, @space_type) >= 0 &&
			    (@space = &disk_space($p->{'device'})) &&
			    $space[0]) {
				printf "%d %%\n", 100 * $space[1] / $space[0];
				}
			print "</td> </tr>\n";
			}
		print "</table>\n";
		}
	if ($usedpri != 4 && $ed) {
		print "<a href=\"edit_part.cgi?",
		      "disk=$d->{'index'}&new=1\">",
		      $text{'index_addpri'},"</a>&nbsp;&nbsp;\n";
		}
	if ($extended && $ed) {
		print "<a href=\"edit_part.cgi?",
		      "disk=$d->{'index'}&new=2\">",
		      $text{'index_addlog'},"</a>\n";
		}
	elsif ($usedpri != 4 && $ed) {
		print "<a href=\"edit_part.cgi?",
		      "disk=$d->{'index'}&new=3\">",
		      $text{'index_addext'},"</a>\n";
		}
	print "</td> </tr>\n";
	}
print "</table><p>\n";

print "<hr>\n";
&footer("/", $text{'index'});

