# debians-linux-lib.pl
# Deal with debian's iptables save file and startup script

# check_iptables()
# Returns an error message if something is wrong with iptables on this system
sub check_iptables
{
if (!-r "/etc/init.d/iptables") {
	return &text('debian_escript', "<tt>/etc/init.d/iptables</tt>");
	}
return undef;
}

$iptables_save_file = "/var/lib/iptables/active";

# apply_iptables()
# Applies the current iptables configuration from the save file
sub apply_iptables
{
local $out = &backquote_logged("cd / ; /etc/init.d/iptables start 2>&1");
return $? ? "<pre>$out</pre>" : undef;
}

# unapply_iptables()
# Writes the current iptables configuration to the save file
sub unapply_iptables
{
$out = &backquote_logged("cd / ; /etc/init.d/iptables save active 2>&1 </dev/null");
return $? ? "<pre>$out</pre>" : undef;
}

# started_at_boot()
sub started_at_boot
{
&foreign_require("init", "init-lib.pl");
return &init::action_status("iptables") == 2;
}

sub enable_at_boot
{
&foreign_require("init", "init-lib.pl");
&init::enable_at_boot("iptables");	 # Assumes init script exists
}

sub disable_at_boot
{
&foreign_require("init", "init-lib.pl");
&init::disable_at_boot("iptables");
}

1;

