#!/usr/local/bin/perl
# index.cgi
# Display a table of all entries from the firewall script

require './firewall-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

# Check if iptables is installed
if (!&has_command("iptables")) {
	print "<p>",&text('index_eiptables', "<tt>iptables</tt>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the kernel supports it
$out = `iptables -L 2>&1`;
if ($?) {
	print "<p>",&text('index_ekernel', "<pre>$out</pre>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Show existing rules
print "<font size=+1>",&text('index_header', "<tt>$firewall_rules_file</tt>"),
      "</font><p>\n";
@rules = &list_rules();
if (@rules) {
	print "<a href='edit_rule.cgi?new=1'>$text{'index_add'}</a><br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td nowrap><b>$text{'index_type'}</b></td> ",
	      "<td nowrap><b>$text{'index_table'}</b></td> ",
	      "<td nowrap><b>$text{'index_chain'}</b></td> ",
	      "<td nowrap><b>$text{'index_desc'}</b></td> ",
	      "<td nowrap><b>$text{'index_move'}</b></td> </tr>\n";
	foreach $r (@rules) {
		print "<tr $cb>\n";
		if ($r->{'type'} == 0) {
			# An iptables firewall rule
			print "<td nowrap><a href='edit_rule.cgi?idx=$r->{'index'}'>",
			      "$text{'index_rule'}</a></td>\n";
			print "<td>",$r->{'table'} || $text{default},"</td>\n";
			print "<td>",$r->{'chain'} || "<br>","</td>\n";
			print "<td>",&describe_rule($r),"</td>\n";
			}
		elsif ($r->{'type'} == 1) {
			# A variable assignment
			print "<td nowrap><a href='edit_var.cgi?idx=$r->{'index'}'>",
			      "$text{'index_var'}</a></td>\n";
			print "<td colspan=2><br></td>\n";
			print "<td><tt>$r->{'name'}</tt> = ",
			      "<tt>$r->{'value'}</tt></td>\n";
			}
		elsif ($r->{'type'} == 2) {
			# Some other piece of script
			print "<td nowrap>$text{'index_script'}</td>\n";
			print "<td colspan=2><br></td>\n";
			print "<td><pre><font size=-1>$r->{'text'}",
			      "</font></pre></td>\n";
			}
		print "<td>";
		if ($r eq $rules[@rules-1]) {
			print "<img src=images/gap.gif>";
			}
		else {
			print "<a href='move.cgi?idx=$r->{'index'}&down=1'>",
			      "<img src=images/down.gif border=0></a>";
			}
		if ($r eq $rules[0]) {
			print "<img src=images/gap.gif>";
			}
		else {
			print "<a href='move.cgi?idx=$r->{'index'}&up=1'>",
			      "<img src=images/up.gif border=0></a>";
			}
		print "</td> </tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit_rule.cgi?new=1'>$text{'index_add'}</a><br>\n";

# Display button to apply firewall configuration
print "<hr>\n";
print "<form action=apply.cgi>\n";
print "<table width=100%><tr>\n";
print "<td><input type=submit value='$text{'index_apply'}'></td>\n";
print "<td>$text{'index_applydesc'}</td>\n";
print "</tr></table></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

