#!/usr/local/bin/perl
# save_dump.cgi
# Save the details of a scheduled backup

require './fsdump-lib.pl';
&foreign_require("cron", "cron-lib.pl");
&ReadParse();
&error_setup($text{'save_err'});

if ($in{'id'}) {
	$dump = &get_dump($in{'id'});
	@jobs = &foreign_call("cron", "list_cron_jobs");
	foreach $j (@jobs) {
		$job = $j if ($j->{'command'} eq "$cron_cmd $dump->{'id'}");
		}
	$oldenabled = $dump->{'enabled'};
	}

if ($in{'delete'}) {
	# Just delete this dump
	&delete_dump($dump);
	if ($job) {
		&lock_file($job->{'file'});
		&foreign_call("cron", "delete_cron_job", $job);
		&unlock_file($job->{'file'});
		}
	&webmin_log("delete", undef, $dump->{'id'}, $dump);
	&redirect("");
	}
elsif ($in{'backup'}) {
	# Redirect to backup page
	&redirect("backup.cgi?id=$in{'id'}");
	}
else {
	# Validate and store inputs
	if ($multiple_directory_support) {
		foreach $d (split(/\s+/, $in{'dir'})) {
			-d $d || &error($text{'save_edir'});
			$fs = &directory_filesystem($d);
			$fs eq $in{'fs'} || &error($text{'save_efs'});
			}
		$in{'dir'} || &error($text{'save_edir'});
		}
	else {
		-d $in{'dir'} || &error($text{'save_edir'});
		$fs = &directory_filesystem($in{'dir'});
		$fs eq $in{'fs'} || &error($text{'save_efs'});
		}
	$dump->{'dir'} = $in{'dir'};
	$dump->{'fs'} = $in{'fs'};
	$dump->{'email'} = $in{'email'};
	$dump->{'subject'} = $in{'subject_def'} ? undef : $in{'subject'};
	$dump->{'before'} = $in{'before'};
	$dump->{'after'} = $in{'after'};
	&parse_dump($dump);
	$dump->{'enabled'} = $in{'enabled'};
	&foreign_call("cron", "parse_times_input", $dump, \%in);

	# Create or update the dump and cron job
	&save_dump($dump);
	local $oldjob = $job;
	if ($dump->{'enabled'}) {
		# Create cron job and script
		$job->{'user'} = 'root';
		$job->{'active'} = 1;
		$job->{'mins'} = $dump->{'mins'};
		$job->{'hours'} = $dump->{'hours'};
		$job->{'days'} = $dump->{'days'};
		$job->{'months'} = $dump->{'months'};
		$job->{'weekdays'} = $dump->{'weekdays'};
		$job->{'command'} = "$cron_cmd $dump->{'id'}";
		open(PERL, "$config_directory/perl-path");
		chop($perl_path = <PERL>);
		close(PERL);
		&lock_file($cron_cmd);
		open(CMD, ">$cron_cmd");
		print CMD <<EOF;
#!$perl_path
open(CONF, "$config_directory/miniserv.conf");
while(<CONF>) {
	\$root = \$1 if (/^root=(.*)/);
	}
close(CONF);
\$ENV{'WEBMIN_CONFIG'} = "$ENV{'WEBMIN_CONFIG'}";
\$ENV{'WEBMIN_VAR'} = "$ENV{'WEBMIN_VAR'}";
chdir("\$root/$module_name");
exec("\$root/$module_name/backup.pl", \$ARGV[0]);
EOF
		close(CMD);
		chmod(0755, $cron_cmd);
		&unlock_file($cron_cmd);
		}
	if ($dump->{'enabled'} && !$oldjob) {
		# Create the cron job
		local %cconfig = &foreign_config("cron");
		local $ctab = "$cconfig{'cron_dir'}/root";
		&lock_file($ctab);
		&foreign_call("cron", "create_cron_job", $job); 
		&unlock_file($ctab);
		}
	elsif ($dump->{'enabled'} && $oldjob) {
		# Update the cron job
		&lock_file($job->{'file'});
		&foreign_call("cron", "change_cron_job", $job); 
		&unlock_file($job->{'file'});
		}
	elsif (!$dump->{'enabled'} && $oldjob) {
		# Delete the cron job
		&lock_file($job->{'file'});
		&foreign_call("cron", "delete_cron_job", $job);
		&unlock_file($job->{'file'});
		}

	&webmin_log($in{'id'} ? "modify" : "create", undef, $dump->{'id'}, $dump);
	if ($in{'savenow'}) {
		&redirect("backup.cgi?id=$dump->{'id'}");
		}
	else {
		&redirect("");
		}
	}

