#!/usr/local/bin/perl
# index.cgi
# Display a list of run-levels and the actions that are run at boot and
# shutdown time for each level

require './inittab-lib.pl';
&header( $text{'inittab_title'}, "", "index", 1, 1, 0,
	&help_search_link("inittab", "man"));

print(
"<hr><a href=new_inittab.cgi>", $text{ 'inittab_new' }, "</a><br>",
"<table border width=\"100%\">",
  "<tr ", $tb, ">",
	"<td><b>", &hlink( $text{ 'inittab_id' }, "id" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_active' }, "active" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_runlevels' }, "runlevels" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_action' }, "action" ), "</b></td>",
	"<td><b>", &hlink( $text{ 'inittab_process' }, "process" ), "</b></td>",
  "</tr>" );

foreach $i (&parse_inittab()) {
	print "<tr $cb>\n";
	print "<td><a href='edit_inittab.cgi?id=$i->{'id'}'>",
		&html_escape($i->{'id'}),"</td>\n";
	print "<td>",$i->{'comment'} ? "<font color=#ff0000>$text{'no'}</font>"
				     : $text{'yes'},"</td>\n";
	local @rls = @{$i->{'levels'}};
	print "<td>",@rls ? &html_escape(join(", ", @rls))
			  : $text{'inittab_none'},"</td>\n";
	print "<td>",($text{"inittab_".$i->{'action'}} ||
		      "<tt>".&html_escape($i->{'action'})."</tt>"),"</td>\n";
	print "<td>",&html_escape($i->{'process'}),"</td>\n";
	print "</tr>\n";
	}

print(
"</table>",
"<a href=new_inittab.cgi>", $text{ 'inittab_new' }, "</a><p>" );

print "<hr>\n";
print "<table width=100%><tr>\n";
print "<form action=apply.cgi>\n";
print "<td><input type=submit value='$text{'inittab_apply'}'></td>\n";
print "<td>$text{'inittab_applymsg'}</td>\n";
print "</form></tr></table><br>\n";

print "<hr>\n";
&footer( "/", $text{'index'} );

