#!/usr/local/bin/perl
# index.cgi
# Display all mailing lists and majordomo options

require './majordomo-lib.pl';
%access = &get_module_acl();

# Check for the majordomo config file
if (!-r $config{'majordomo_cf'}) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("majordomo", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_econfig', "<tt>$config{'majordomo_cf'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check for the programs dir
if (!-d $config{'program_dir'}) {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("majordomo", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_eprograms', "<tt>$config{'program_dir'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check majordomo version
if (!-r "$config{'program_dir'}/majordomo_version.pl") {
	&header($text{'index_title'}, "", undef, 1, 1, 0,
		&help_search_link("majordomo", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>$text{'index_eversion'}<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
require "$config{'program_dir'}/majordomo_version.pl";
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("majordomo", "man", "doc", "google"),
	undef, undef, &text('index_version', $majordomo_version));
print "<hr>\n";
if ($majordomo_version < 1.94 || $majordomo_version >= 2) {
	print "<p>$text{'index_eversion'}<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check $homedir in majordomo.cf
$conf = &get_config();
$homedir = &find_value("homedir", $conf);
if (!-d $homedir) {
	# No! But is it actually used?
	foreach $c (@$conf) {
		$homeused++ if ($c->{'value'} =~ /\$homedir/);
		}
	if ($homeused) {
		print "<p>",&text('index_ehomedir',
				  "<tt>$homedir</tt>"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

# Check $listdir in majordomo.cf
$listdir = &perl_var_replace(&find_value("listdir", $conf), $conf);
if (!-d $listdir) {
	print "<p>",&text('index_elistdir', "<tt>$listdir</tt>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

if ($config{'aliases_file'}) {
	# aliases file specified in config
	$aliases_files = [ $config{'aliases_file'} ];
	}
else {
	# Check if sendmail is setup
	%smconfig = &foreign_config("sendmail");
	if (!-r $smconfig{'sendmail_cf'}) {
		print "<p>",&text('index_esendmail',
				  "<tt>$smconfig{'sendmail_cf'}</tt>"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}

	# Check if sendmail is the right version for the sendmail module
	$sm_conf = &foreign_call("sendmail", "get_sendmailcf");
	if (!&foreign_call("sendmail", "check_sendmail_version", $sm_conf)) {
		print "<p>$text{'index_esendmailversion'}<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	$aliases_files = &foreign_call("sendmail", "aliases_file", $sm_conf);
	}

# Check for the majordomo aliases
$email = &find_value("whoami", $conf); $email =~ s/\@.*$//g;
$owner = &find_value("whoami_owner", $conf); $owner =~ s/\@.*$//g;
@aliases = &foreign_call("sendmail", "list_aliases", $aliases_files);
foreach $a (@aliases) {
	if ($a->{'enabled'} && lc($a->{'name'}) eq lc($email)) {
		$majordomo_alias = 1;
		}
	if ($a->{'enabled'} && lc($a->{'name'}) eq lc($owner)) {
		$majordomo_owner = 1;
		}
	}

# Offer to setup aliases
if (!$majordomo_alias) {
	print "<p>$text{'index_setupdesc'}\n";
	print "<center><form action=alias_setup.cgi>\n";
	if (!$majordomo_owner) {
		print "<b>$text{'index_owner'}</b>\n";
		print "<input name=owner size=25>\n";
		print "<input type=hidden name=owner_a value='$owner'>\n";
		}
	print "<input type=hidden name=email_a value='$email'>\n";
	print "<input type=submit value=\"$text{'index_setup'}\">\n";
	print "</form></center>\n";
	print "<hr>\n";
	}

# Display active lists
@lists = &list_lists($conf);
@lists = sort { $a cmp $b } @lists if ($config{'sort_mode'});
map { $lcan{$_}++ } split(/\s+/, $access{'lists'});
foreach $l (grep { $lcan{$_} || $lcan{"*"} } @lists) {
	push(@links, "edit_list.cgi?name=$l");
	push(@titles, &html_escape($l));
	push(@icons, "images/list.gif");
	}
if (@links) {
	print "<a href='create_form.cgi'>$text{'index_add'}</a>\n";
	if (@links) {
		print "&nbsp;&nbsp;\n";
		print "<a href='digest_form.cgi'>$text{'index_digest'}</a>\n";
		}
	print "<br>\n";
	&icons_table(\@links, \@titles, \@icons, 5);
	}
else {
	print "<b>$text{'index_none'}</b>.<p>\n";
	}
if ($access{'create'}) {
	print "<a href='create_form.cgi'>$text{'index_add'}</a>\n";
	if (@links) {
		print "&nbsp;&nbsp;\n";
		print "<a href='digest_form.cgi'>$text{'index_digest'}</a>\n";
		}
	print "<p>\n";
	}

if ($access{'global'}) {
	print "<hr>\n";
	print "<table> <tr>\n";
	print "<form action=edit_global.cgi>\n";
	print "<td><input type=submit value='$text{'index_global'}'></td>\n";
	print "<td>$text{'index_globaldesc'}</td> </tr> </form>\n";
	print "</table>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

