# oschooser.pl
# Read the list of operating systems and ask the user to choose
# an OS and version
# auto param: 0 = always ask user
#	      1 = automatic, give up if fails
#	      2 = automatic, ask user if fails
#             3 = automatic, ask user if fails and if a TTY

$| = 1;

($oslist, $out, $auto) = @ARGV;
open(OS, $oslist) || die "failed to open $oslist : $!";
while(<OS>) {
	chop;
	if (/^([^\t]+)\t+([^\t]+)\t+(\S+)\t+(\S+)\t*(.*)$/) {
		push(@list, [ $1, $2, $3, $4, $5 ]);
		push(@names, $1) if (!$donename{$1}++);
		}
	}
close(OS);

if ($auto) {
	# Try to guess the OS name and version
	if (-r "/etc/.issue") {
		$etc_issue = `cat /etc/.issue`;
		}
	elsif (-r "/etc/issue") {
		$etc_issue = `cat /etc/issue`;
		}
	$uname = `uname -a`;
	foreach $o (@list) {
		if ($o->[4] && eval $o->[4]) {
			# Got a match!
			$ver = $o;
			last;
			}
		}
	if (!$ver) {
		if ($auto == 1) {
			# Failed .. give up
			print "Failed to detect operating system\n";
			exit 1;
			}
		elsif ($auto == 3) {
			# Do we have a tty?
			local $rv = system("tty >/dev/null 2>&1");
			if ($?) {
				print "Failed to detect operating system\n";
				exit 1;
				}
			else {
				$auto = 0;
				}
			}
		else {
			# Ask the user
			$auto = 0;
			}
		}
	}

if (!$auto) {
	if (0 && &has_command("dialog")) {
		# call the dialog command to ask for the OS (disabled for now)
		$cmd = "dialog --menu \"Please select your operating system type from the list below\" 20 60 12";
		for($i=0; $i<@names; $i++) {
			$cmd .= " ".($i+1)." '$names[$i]'";
			}
		$temp = "/tmp/.webmin/dialog.out";
		system("$cmd 2>$temp");
		$osnum = `cat $temp`;
		$osnum = int($osnum);
		if (!$osnum) {
			#unlink($temp);
			print "ERROR: No operating system selected\n\n";
			exit 9;
			}

		# call the dialog command to ask for the version
		$name = $names[$osnum-1];
		@vers = grep { $_->[0] eq $name } @list;
		$cmd = "dialog --menu \"Please select your operating system's version from the list below\" 20 60 12";
		for($i=0; $i<@vers; $i++) {
			$cmd .= " ".($i+1)." '$name $vers[$i]->[1]'";
			}
		system("$cmd 2>$temp");
		$vnum = `cat $temp`;
		$vnum = int($vnum);
		unlink($temp);
		if (!$vnum) {
			print "ERROR: No operating system version selected\n\n";
			exit 9;
			}
		$ver = $vers[$vnum-1];
		}
	else {
		# ask for the operating system name ourselves
		$dashes = "-" x 75;
		print <<EOF;
For Webmin to work properly, it needs to know which operating system
type and version you are running. Please select your system type by
entering the number next to it from the list below
$dashes
EOF
		for($i=0; $i<@names; $i++) {
			printf " %2d) %-20.20s ", $i+1, $names[$i];
			print "\n" if ($i%3 == 2);
			}
		print "\n" if ($i%3);
		print $dashes,"\n";
		print "Operating system: ";
		chop($osnum = <STDIN>);
		if ($osnum !~ /^\d+$/) {
			print "ERROR: You must enter the number next to your operating\n";
			print "system, not its name or version number.\n\n";
			exit 9;
			}
		if ($osnum < 1 || $osnum > @names) {
			print "ERROR: $osnum is not a valid operating system number.\n\n";
			exit 10;
			}
		print "\n";

		# Ask for the operating system version
		$name = $names[$osnum-1];
		@vers = grep { $_->[0] eq $name } @list; 
		print <<EOF;
Please choose which version of $name you are running, by entering
the number next to it from the list below
$dashes
EOF
		for($i=0; $i<@vers; $i++) {
			printf " %2d) %-34.34s ", $i+1, $name." ".$vers[$i]->[1];
			print "\n" if ($i%2);
			}
		print "\n" if ($i%2);
		print $dashes,"\n";
		print "Version: ";
		chop($vnum = <STDIN>);
		if ($vnum !~ /^\d+$/) {
			print "ERROR: You must enter the number next to your operating\n";
			print "system version, not its name or version number.\n\n";
			exit 9;
			}
		if ($vnum < 1 || $vnum > @vers) {
			print "ERROR: $vnum is not a valid operating system number.\n\n";
			exit 10;
			}
		print "\n";
		$ver = $vers[$vnum-1];
		}
	}

# Write the name, version and real name and version to a file
open(OUT, ">$out");
print OUT "os_type='",$ver->[2],"'\n";
print OUT "os_version='",$ver->[3],"'\n";
print OUT "real_os_type='",$ver->[0],"'\n";
print OUT "real_os_version='",$ver->[1],"'\n";
close(OUT);

# has_command(command)
# Returns the full path if some command is in the path, undef if not
sub has_command
{
local($d);
if (!$_[0]) { return undef; }
local $rv = undef;
if ($_[0] =~ /^\//) {
	$rv = (-x $_[0]) ? $_[0] : undef;
	}
else {
	foreach $d (split(/:/ , $ENV{PATH})) {
		if (-x "$d/$_[0]") { $rv = "$d/$_[0]"; last; }
		}
	}
return $rv;
}


