# pap-lib.pl
# Functions for managing the pap-secrets file
# XXX callback support http://www.tldp.org/HOWTO/mini/Call-back-2.html

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

# list_secrets()
sub list_secrets
{
local(@rv, $line, $_);
open(SEC, $config{'pap_file'});
$line = 0;
while(<SEC>) {
	chop;
	s/^#.*$//g;
	@w = &split_words($_);
	if (@w >= 3) {
		local(%sec, @ips);
		$sec{'client'} = $w[0];
		$sec{'server'} = $w[1];
		$sec{'secret'} = $w[2];
		@ips = @w[3..$#w];
		$sec{'ips'} = \@ips;
		$sec{'line'} = $line;
		push(@rv, \%sec);
		}
	$line++;
	}
close(SEC);
return @rv;
}

# create_secret(&secret)
sub create_secret
{
open(SEC, ">>$config{'pap_file'}");
print SEC &join_words($_[0]->{'client'}, $_[0]->{'server'},
		      $_[0]->{'secret'}, @{$_[0]->{'ips'}}),"\n";
close(SEC);
}

# change_secret(&secret)
sub change_secret
{
&replace_file_line($config{'pap_file'}, $_[0]->{'line'},
		   &join_words($_[0]->{'client'}, $_[0]->{'server'},
			       $_[0]->{'secret'}, @{$_[0]->{'ips'}})."\n");
}

# delete_secret(&secret)
sub delete_secret
{
&replace_file_line($config{'pap_file'}, $_[0]->{'line'});
}

# split_words(string)
sub split_words
{
local($s, @w);
$s = $_[0];
while($s =~ /^\s*([^"\s]+|"([^"]*)")(.*)$/) {
	push(@w, defined($2) ? $2 : $1);
	$s = $3;
	}
return @w;
}

sub join_words
{
local(@w, $w);
foreach $w (@_) {
	if ($w =~ /^\S+$/) { push(@w, $w); }
	else { push(@w, "\"$w\""); }
	}
return join("  ", @w);
}

# opt_crypt(password)
# Returns the given password, crypted if the user has configured it
sub opt_crypt
{
if ($config{'encrypt_pass'}) {
	local($salt);
	srand(time());
	$salt = chr(int(rand(26))+65).chr(int(rand(26))+65);
	return crypt($_[0], $salt);
	}
return $_[0];
}

# mgetty_inittabs()
# Returns a list of inittab entries for mgetty, with options parsed
sub mgetty_inittabs
{
local @rv;
foreach $i (&inittab::parse_inittab()) {
	if ($i->{'process'} =~ /^(\S*mgetty)\s*(.*)\s+((\/.*)?(tty|term|cua)\S+)(\s+(\S+))?$/) {
		$i->{'mgetty'} = $1;
		$i->{'args'} = $2;
		$i->{'tty'} = $3;
		$i->{'ttydefs'} = $7;
		if ($i->{'args'} =~ s/\s*-s\s+(\d+)//) {
			$i->{'speed'} = $1;
			}
		if ($i->{'args'} =~ s/\s*-r//) {
			$i->{'direct'} = 1;
			}
		if ($i->{'args'} =~ s/\s*-n\s+(\d+)//) {
			$i->{'rings'} = $1;
			}
		if ($i->{'args'} =~ s/\s*-D//) {
			$i->{'data'} = 1;
			}
		if ($i->{'args'} =~ s/\s*-F//) {
			$i->{'fax'} = 1;
			}
		if ($i->{'args'} =~ s/\s*-R\s+(\d+)//) {
			$i->{'back'} = $1;
			}
		if ($i->{'args'} =~ s/\s*-p\s+'([^']+)'// ||
		    $i->{'args'} =~ s/\s*-p\s+"([^"]+)"// ||
		    $i->{'args'} =~ s/\s*-p\s+(\S+)//) {
			$i->{'prompt'} = $1;
			}
		push(@rv, $i);
		}
	elsif ($i->{'process'} =~ /^(\S*vgetty)\s*(.*)\s+((\/.*)?tty\S+)/) {
		$i->{'vgetty'} = $1;
		$i->{'args'} = $2;
		$i->{'tty'} = $3;
		push(@rv, $i);
		}
	}
return @rv;
}

# parse_ppp_options(file)
sub parse_ppp_options
{
local @rv;
local $lnum = 0;
open(OPTS, $_[0]);
while(<OPTS>) {
	s/\r|\n//g;
	s/#.*$//g;
	if (/^([0-9\.]+):([0-9\.]+)/) {
		push(@rv, { 'local' => $1,
			    'remote' => $2,
			    'file' => $_[0],
			    'line' => $lnum,
			    'index' => scalar(@rv) });
		}
	elsif (/^(\S+)\s*(.*)/) {
		push(@rv, { 'name' => $1,
			    'value' => $2,
			    'file' => $_[0],
			    'line' => $lnum,
			    'index' => scalar(@rv) });
		}
	$lnum++;
	}
close(OPTS);
return @rv;
}

# find(name, &config)
sub find
{
local @rv = grep { lc($_->{'name'}) eq lc($_[0]) } @{$_[1]};
return wantarray ? @rv : $rv[0];
}

# save_ppp_option(&config, file, &old|name, &new)
sub save_ppp_option
{
local $ol = ref($_[2]) || !defined($_[2]) ? $_[2] : &find($_[2], $_[0]);
local $nw = $_[3];
local $lref = &read_file_lines($_[1]);
local $line;
if ($nw) {
	if ($nw->{'local'}) {
		$line = $nw->{'local'}.":".$nw->{'remote'};
		}
	else {
		$line = $nw->{'name'};
		$line .= " $nw->{'value'}" if ($nw->{'value'} ne "");
		}
	}
if ($ol && $nw) {
	$lref->[$ol->{'line'}] = $line;
	}
elsif ($ol) {
	splice(@$lref, $ol->{'line'}, 1);
	local $c;
	foreach $c (@{$_[0]}) {
		$c->{'line'}-- if ($c->{'line'} > $ol->{'line'});
		}
	}
elsif ($nw) {
	push(@$lref, $line);
	}
}

# parse_login_config()
# Parses the mgetty login options file into a list of users
sub parse_login_config
{
local @rv;
local $lnum = 0;
open(LOGIN, $config{'login_config'});
while(<LOGIN>) {
	s/\r|\n//g;
	s/#.*$//g;
	if (/^(\S+)\s+(\S+)\s+(\S+)\s+(.*)/) {
		push(@rv, { 'user' => $1,
			    'userid' => $2,
			    'utmp' => $3,
			    'program' => $4,
			    'line' => $lnum });
		}
	$lnum++;
	}
close(LOGIN);
return @rv;
}

# delete_login_config(&config, &login)
sub delete_login_config
{
local $lref = &read_file_lines($config{'login_config'});
splice(@$lref, $_[1]->{'line'}, 1);
}

# create_login_config(&config, &login)
sub create_login_config
{
local ($star) = grep { $_->{'user'} eq '*' } @{$_[0]};
local $line = join("\t", $_[1]->{'user'}, $_[1]->{'userid'},
			 $_[1]->{'utmp'}, $_[1]->{'program'});
local $lref = &read_file_lines($config{'login_config'});
if ($star) {
	splice(@$lref, $star->{'line'}, 0, $line);
	}
else {
	push(@$lref, $line);
	}
}

# parse_dialin_config()
# Parses the mgetty dialin file
sub parse_dialin_config
{
local @rv;
local $lnum = 0;
open(DIALIN, $config{'dialin_config'});
while(<DIALIN>) {
	s/\r|\n//g;
	s/#.*$//g;
	s/^\s+//;
	local $t;
	foreach $t (split(/[ \t,]+/, $_)) {
		local ($not) = ($t =~ s/^\!//);
		push(@rv, { 'number' => $t,
			    'not' => $not,
			    'index' => scalar(@rv),
			    'line' => $lnum });
		}
	$lnum++;
	}
close(DIALIN);
return @rv;
}

# create_dialin(&dialin)
sub create_dialin
{
open(DIALIN, ">>$config{'dialin_config'}");
print DIALIN &dialin_line($_[0])."\n";
close(DIALIN);
}

# delete_dialin(&dialin, &config)
sub delete_dialin
{
local @same = grep { $_->{'line'} == $_[0]->{'line'} && $_ ne $_[0] }
		   @{$_[1]};
if (@same) {
	&replace_file_line($config{'dialin_config'}, $_[0]->{'line'},
			   join(" ", map { &dialin_line($_) } @same)."\n");
	}
else {
	&replace_file_line($config{'dialin_config'}, $_[0]->{'line'});
	}
}

# modify_dialin(&dialin, &config)
sub modify_dialin
{
local @same = grep { $_->{'line'} == $_[0]->{'line'} } @{$_[1]};
&replace_file_line($config{'dialin_config'}, $_[0]->{'line'},
		   join(" ", map { &dialin_line($_) } @same)."\n");
}

# swap_dialins(&dialin1, &dialin2, &config)
sub swap_dialins
{
local $lref = &read_file_lines($config{'dialin_config'});
local @same1 = grep { $_->{'line'} == $_[0]->{'line'} } @{$_[2]};
local @same2 = grep { $_->{'line'} == $_[1]->{'line'} } @{$_[2]};
local $idx1 = &indexof($_[0], @same1);
local $idx2 = &indexof($_[1], @same2);
if ($_[0]->{'line'} == $_[1]->{'line'}) {
	($same1[$idx1], $same1[$idx2]) = ($same1[$idx2], $same1[$idx1]);
	&replace_file_line($config{'dialin_config'}, $_[0]->{'line'},
			   join(" ", map { &dialin_line($_) } @same1)."\n");
	}
else {
	($same1[$idx1], $same2[$idx2]) = ($same2[$idx2], $same1[$idx1]);
	&replace_file_line($config{'dialin_config'}, $_[0]->{'line'},
			   join(" ", map { &dialin_line($_) } @same1)."\n");
	&replace_file_line($config{'dialin_config'}, $_[1]->{'line'},
			   join(" ", map { &dialin_line($_) } @same2)."\n");
	}
}

# dialin_line(&dialin)
sub dialin_line
{
return ($_[0]->{'not'} ? "!" : "").$_[0]->{'number'};
}

1;

