#!/usr/local/bin/perl
# boxes.cgi
# List the mailboxes of all local users

require './postfix-lib.pl';
require './boxes-lib.pl';

&header($text{'boxes_title'}, "");
print "<hr>\n";

$s = &postfix_mail_system();
setpwent();
while(@u = getpwent()) {
	local $umf = &postfix_mail_file(@u);
	next if ($donefile{$umf}++);
	if ($s < 2) {
		local @st = stat($umf);
		push(@users, [ $u[0], $st[7] ]);
		}
	else {
		local $sz = 0;
		foreach $d ("$umf/cur", "$umf/new", "$umf/tmp") {
			opendir(DIR, $d) || last;
			foreach $f (readdir(DIR)) {
				local @st = stat("$d/$f");
				$sz += $st[7];
				}
			closedir(DIR);
			}
		push(@users, [ $u[0], $sz ]);
		}
	}
endpwent() if ($gconfig{'os_type'} ne 'hpux');
@users = sort { $b->[1] <=> $a->[1] } @users;

if ($config{'max_records'} && @users > $config{'max_records'}) {
	# Use input for jumping to one user
	print $text{'boxes_toomany'},"<br>\n";
	print "<form action=list_mail.cgi>\n";
	print "<input type=submit value='$text{'boxes_go'}'>\n";
	print &unix_user_input("user"),"</form>\n";
	}
else {
	# Show table of users
	print "<table width=100%><tr><td valign=top width=50%>\n";
	$mid = int((@users+1) / 2);
	&users_table(@users[0 .. $mid-1]);
	print "</td><td valign=top width=50%>\n";
	&users_table(@users[$mid .. $#users]);
	print "</td></tr></table><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

sub users_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'boxes_user'}</b></td> ",
      "<td><b>$text{'boxes_size'}</b></td> </tr>\n";
foreach $u (@_) {
	print "<tr $cb> <td><a href=\"list_mail.cgi?user=$u->[0]\">",
	      "$u->[0]</a></td>\n";
	print "<td>",defined($u->[1]) ? $u->[1]
				      : $text{'boxes_none'},"</td> </tr>\n";
	}
print "</table>\n";
}

