#!/usr/local/bin/perl
# send_mail.cgi
# Send off an email message

require './postfix-lib.pl';
require './boxes-lib.pl';

# Check inputs
&ReadParseMime();
&error_setup($text{'send_err'});
$in{'to'} || &error($text{'send_eto'});
$in{'from'} || &error($text{'send_efrom'});

# Construct the email
$mail->{'headers'} = [ [ 'From', $in{'from'} ],
		       [ 'Subject', $in{'subject'} ],
		       [ 'To', $in{'to'} ],
		       [ 'Cc', $in{'cc'} ],
		       [ 'Bcc', $in{'bcc'} ],
		       [ 'X-Originating-IP', $ENV{'REMOTE_ADDR'} ],
		       [ 'X-Mailer', "Webmin ".&get_webmin_version() ] ];
push(@{$mail->{'headers'}}, [ 'X-Priority', $in{'pri'} ]) if ($in{'pri'});
$in{'body'} =~ s/\r//g;
if ($in{'body'} =~ /\S/) {
	@attach = ( { 'headers' => [ [ 'Content-Type', 'text/plain' ],
				     [ 'Content-Transfer-Encoding', '7bit' ] ],
		      'data' => $in{'body'} } );
	}
foreach $i (0 .. 5) {
	# Add uploaded attachment
	next if (!$in{"attach$i"});
	local $filename = $in{"attach${i}_filename"};
	$filename =~ s/^.*(\\|\/)//;
	local $type = $in{"attach${i}_content_type"}."; name=\"".
		      $filenam3."\"";
	local $disp = "inline; filename=\"".$filename."\"";
	push(@attach, { 'data' => $in{"attach${i}"},
			'headers' => [ [ 'Content-type', $type ],
				       [ 'Content-Disposition', $disp ],
				       [ 'Content-Transfer-Encoding',
					 'base64' ] ] });
	$atotal += length($in{"attach${i}"});
	}
foreach $i (0 .. 2) {
	# Add server-side attachment
	next if (!$in{"file$i"});
	-r $in{"file$i"} || &error(&text('send_efile', $in{"file$i"}));
	if ($in{'user'} ne 'root') {
		# Is this mailbox user allowed to read the attachment?
		pipe(CHr, CHw);
		if (!fork()) {
			close(CHr);
			@u = getpwnam($in{'user'});
			$( = $u[3]; $) = "$u[3] $u[3]";
			($>, $<) = ($u[2], $u[2]);
			if (!open(TEST, $in{"file$i"})) {
				print CHw "$!\n";
				}
			exit;
			}
		close(CHw);
		chop($resp = <CHr>);
		close(CHr);
		$resp && &error(&text('send_eperms',
				      $in{'user'}, $in{"file$i"}));
		}
	local $data;
	open(DATA, $in{"file$i"}) || &error(&text('send_efile', $in{"file$i"}));
	while(<DATA>) {
		$data .= $_;
		}
	close(DATA);
	$in{"file$i"} =~ s/^.*\///;
	local $type = &guess_type($in{"file$i"})."; name=\"".$in{"file$i"}."\"";
	local $disp = "inline; filename=\"".$in{"file$i"}."\"";
	push(@attach, { 'data' => $data,
			'headers' => [ [ 'Content-type', $type ],
				       [ 'Content-Disposition', $disp ],
				       [ 'Content-Transfer-Encoding',
					 'base64' ] ] });
	$atotal += length($data);
	}
@fwd = split(/\0/, $in{'forward'});
$umf = &postfix_mail_file($in{'user'});
$s = &postfix_mail_system();
if (@fwd) {
	# Add forwarded attachments
	@mail = $s == 1 ?
		&list_maildir($umf, $in{'idx'}, $in{'idx'}) :
		&list_mails($umf, $in{'idx'}, $in{'idx'});
	$fwdmail = $mail[$in{'idx'}];
	&parse_mail($fwdmail);
	foreach $f (@fwd) {
		push(@attach, $fwdmail->{'attach'}->[$f]);
		$atotal += length($fwdmail->{'attach'}->[$f]->{'data'});
		}
	}
@mailfwd = split(/\0/, $in{'mailforward'});
if (@mailfwd) {
	# Add forwarded emails
	@mail = $s == 1 ?
		&list_maildir($umf, $mailfwd[0], $mailfwd[@mailfwd-1]) :
		&list_mails($umf, $mailfwd[0], $mailfwd[@mailfwd-1]);
	foreach $f (@mailfwd) {
		$fwdmail = $mail[$f];
		local $headertext;
		foreach $h (@{$fwdmail->{'headers'}}) {
			$headertext .= $h->[0].": ".$h->[1]."\n";
			}
		push(@attach, { 'data' => $headertext."\n".$fwdmail->{'body'},
				'headers' => [ [ 'Content-type', 'message/rfc822' ],
					       [ 'Content-Description',
						  $fwdmail->{'header'}->{'subject'} ] ]
			      });
		}
	}
$mail->{'attach'} = \@attach;

# Send it off
&send_mail($mail);
&webmin_log("send", undef, undef, { 'from' => $in{'from'}, 'to' => $in{'to'} });
&header($text{'send_title'}, "");
print "<hr>\n";

print "<p>",&text('send_ok', "<tt>".&html_escape($in{'to'})."</tt>"),"<p>\n";
print "<hr>\n";
if ($in{'idx'} ne '') {
	&footer("view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}",
		$text{'view_return'},
		"list_mail.cgi?user=$in{'user'}", $text{'mail_return'},
		"boxes.cgi", $text{'boxes_return'},
		"", $text{'index_return'});
	}
else {
	&footer("list_mail.cgi?user=$in{'user'}", $text{'mail_return'},
		"boxes.cgi", $text{'boxes_return'},
		"", $text{'index_return'});
	}

