#!/usr/local/bin/perl
# view_mail.cgi
# View a single email message 

require './postfix-lib.pl';
require './boxes-lib.pl';

$force_charset = '';
&ReadParse();

&header($text{'view_title'}, "");
$umf = &postfix_mail_file($in{'user'});
$s = &postfix_mail_system();
@mail = $s == 2 ?
	&list_maildir($umf, $in{'idx'}, $in{'idx'}) :
	&list_mails($umf, $in{'idx'}, $in{'idx'});
$mail = $mail[$in{'idx'}];
&parse_mail($mail);
@sub = split(/\0/, $in{'sub'});
$subs = join("", map { "&sub=$_" } @sub);
foreach $s (@sub) {
	# We are looking at a mail within a mail ..
	local $amail = &extract_mail($mail->{'attach'}->[$s]->{'data'});
	&parse_mail($amail);
	$mail = $amail;
	}

print "<center>\n";
if (!@sub) {
	if ($in{'idx'}) {
		print "<a href='view_mail.cgi?user=$in{'user'}&idx=",
		      $in{'idx'}-1,"'><img src=/images/left.gif border=0 ",
		      "align=middle></a>\n";
		}
	print "<font size=+1>",&text('view_desc', $in{'idx'}+1,
				     "<tt>$umf</tt>"),"</font>\n";
	if ($in{'idx'} < @mail-1) {
		print "<a href='view_mail.cgi?user=$in{'user'}&idx=",
		      $in{'idx'}+1,"'><img src=/images/right.gif border=0 ",
		      "align=middle></a>\n";
		}
	}
else {
	print "<font size=+1>$text{'view_sub'}</font>\n";
	}
print "</center>\n";
print "<hr>\n";

print "<form action=reply_mail.cgi>\n";
print "<input type=hidden name=user value='$in{'user'}'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";

# Find body attachment
@attach = @{$mail->{'attach'}};
foreach $a (@attach) {
	if ($a->{'type'} eq 'text/plain' || $a->{'type'} eq 'text') {
		$body = $a;
		last;
		}
	}
@attach = grep { $_ ne $body } @attach;
@attach = grep { !$_->{'attach'} } @attach;

if ($config{'top_buttons'} == 2 && !@sub) {
	&show_buttons(1);
	print "<p>\n";
	}

print "<table width=100% border=1>\n";
print "<tr> <td $tb><table width=100% cellpadding=0 cellspacing=0><tr>",
      "<td><b>$text{'view_headers'}</b></td>\n";
if ($in{'headers'}) {
	print "<td align=right><a href='view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}&headers=0$subs'>$text{'view_noheaders'}</a></td>\n";
	}
else {
	print "<td align=right><a href='view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}&headers=1$subs'>$text{'view_allheaders'}</a></td>\n";
	}
print "</tr></table></td> </tr>\n";

print "<tr> <td $cb><table width=100%>\n";
if ($in{'headers'}) {
	# Show all the headers
	if ($mail->{'fromline'}) {
		print "<tr> <td><b>$text{'mail_rfc'}</b></td>",
		      "<td>",&eucconv(&html_escape($mail->{'fromline'})),
		      "</td> </tr>\n";
		}
	foreach $h (@{$mail->{'headers'}}) {
		print "<tr> <td><b>$h->[0]:</b></td> ",
		      "<td>",&eucconv(&html_escape(&decode_mimewords($h->[1]))),
		      "</td> </tr>\n";
		}
	}
else {
	# Just show the most useful headers
	print "<tr> <td><b>$text{'mail_from'}</b></td> ",
	      "<td>",&eucconv(&html_escape(&decode_mimewords(
			$mail->{'header'}->{'from'}))),"</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_to'}</b></td> ",
	      "<td>",&eucconv(&html_escape(&decode_mimewords(
			$mail->{'header'}->{'to'}))),"</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_cc'}</b></td> ",
	      "<td>",&eucconv(&html_escape(&decode_mimewords(
			$mail->{'header'}->{'cc'}))),"</td> </tr>\n"
		if ($mail->{'header'}->{'cc'});
	print "<tr> <td><b>$text{'mail_date'}</b></td> ",
	      "<td>",&eucconv(&html_escape($mail->{'header'}->{'date'})),
	      "</td> </tr>\n";
	print "<tr> <td><b>$text{'mail_subject'}</b></td> ",
	      "<td>",&eucconv(&html_escape(&decode_mimewords(
			$mail->{'header'}->{'subject'}))),"</td> </tr>\n";
	}
print "</table></td></tr></table><p>\n";

# Show body attachment
if ($body) {
	print "<table width=100% border=1><tr><td $cb><pre>\n";
	foreach $l (&wrap_lines($body->{'data'}, $config{'wrap_width'})) {
		print &link_urls(&eucconv(&html_escape($l))),"\n";
		}
	print "</pre></td></tr></table><p>\n";
	}

# Display other attachments
if (@attach) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'view_attach'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $a (@attach) {
		local $fn;
		$size = (int(length($a->{'data'})/1000)+1)." Kb";
		if ($a->{'type'} eq 'message/rfc822') {
			push(@titles, "$text{'view_sub'}<br>$size");
			}
		elsif ($a->{'filename'}) {
			push(@titles, &decode_mimewords($a->{'filename'}).
				      "<br>$size");
			$fn = &decode_mimewords($a->{'filename'});
			}
		else {
			push(@titles, "$a->{'type'}<br>$size");
			$a->{'type'} =~ /\/(\S+)$/;
			$fn = "file.$1";
			}
		$fn =~ s/ /_/g;
		$fn = &html_escape($fn);
		if ($a->{'type'} eq 'message/rfc822') {
			push(@links, "view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}$subs&sub=$a->{'idx'}");
			}
		else {
			push(@links, "detach.cgi/$fn?user=$in{'user'}&idx=$in{'idx'}&attach=$a->{'idx'}$subs");
			}
		push(@icons, "images/boxes.gif");
		}
	&icons_table(\@links, \@titles, \@icons, 8);
	print "</td></tr></table><p>\n";
	}

&show_buttons(2) if (!@sub);
print "</form>\n";

print "<hr>\n";
local @sr = !@sub ? ( ) :
    ( "view_mail.cgi?user=$in{'user'}&idx=$in{'idx'}", $text{'view_return'} ),
$s = int((@mail - $in{'idx'} - 1) / $config{'perpage'}) * $config{'perpage'};
&footer(@sr, "list_mail.cgi?user=$in{'user'}&start=$s", $text{'mail_return'},
	"boxes.cgi", $text{'boxes_return'},
	"", $text{'index_return'});

# show_buttons(pos)
sub show_buttons
{
if ($sentbox) {
	print "<input type=submit value=\"$text{'view_enew'}\" name=enew>\n";
	}
else {
	print "<input type=submit value=\"$text{'view_reply'}\" name=reply>\n";
	print "<input type=submit value=\"$text{'view_reply2'}\" name=rall>\n";
	}
print "<input type=submit value=\"$text{'view_forward'}\" name=forward>\n";
print "&nbsp;&nbsp;&nbsp;\n";
print "<input type=submit value=\"$text{'view_delete'}\" name=delete>\n";
if (@attach) {
	print "<input type=submit value=\"$text{'view_strip'}\" name=strip>\n";
	}

}

