#!/usr/local/bin/perl
# index.cgi
# Display all existing databases

require './postgresql-lib.pl';

# Check for PostgreSQL program
if (!-x $config{'psql'}) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_esql', "<tt>$config{'psql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check for the config file
if (!-r $config{'hba_conf'}) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print "<hr>\n";
	if ($config{'setup_cmd'}) {
		# Offer to setup DB for first time
		print "<p>",&text('index_setup', "<tt>$config{'hba_conf'}</tt>",
				  "<tt>$config{'setup_cmd'}</tt>"),"<br>\n";
		print "<form action=setup.cgi><center>\n";
		print "<input type=submit value='$text{'index_setupok'}'>\n";
		print "</center></form><p>\n";
		}
	else {
		# Config file wasn't found
		print "<p>",&text('index_ehba', "<tt>$config{'hba_conf'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		}
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

$r = &is_postgresql_running();
if ($r == 0) {
	# Not running .. need to start it
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p> <b>$text{'index_notrun'}</b> <p>\n";

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_start'}\"></td>\n";
		print "<td>",&text('index_startmsg',
		      "<tt>$config{'start_cmd'}</tt>"),"</td> </tr></table>\n";
		print "</form>\n";
		}
	}
elsif ($r == -1) {
	# Running, but webmin doesn't know the login/password
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p> <b>$text{'index_nopass'}</b> <p>\n";
	print "<form action=login.cgi method=post>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'index_ltitle'}</b></td> </tr>\n";
	print "<tr $cb> <td><table cellpadding=2>\n";
	print "<tr> <td><b>$text{'index_login'}</b></td>\n";
	printf "<td><input name=login size=20 value='%s'></td> </tr>\n",
		$config{'login'};
	print "<tr> <td><b>$text{'index_pass'}</b></td>\n";
	print "<td><input name=pass size=20 type=password></td>\n";
	print "</tr> </table></td></tr></table>\n";
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=reset value='$text{'index_clear'}'>\n";
	print "</center></form>\n";
	}
elsif ($r == -2) {
	# Looks like a shared library problem
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_elibrary', "<tt>$config{'psql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<p>",&text('index_ldpath', "<tt>$ENV{$gconfig{'ld_env'}}</tt>",
			  "<tt>$config{'psql'}</tt>"),"<br>\n";
	print "<pre>$out</pre>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
else {
	# Running .. check version
	$v = &get_postgresql_version();
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"),
		undef, undef, &text('index_version', $v));
	print "<hr>\n";
	unless (defined $v) {
	        print "<p>",&text('index_superuser',"$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	if ($v < 6.5) {
		print "<p>",&text('index_eversion', $v, 6.5),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}

	# List the databases
	print "<h3>$text{'index_dbs'}</h3>\n";
	@titles = grep { &can_edit_db($_) } &list_databases();
	@icons = map { "images/db.gif" } @titles;
	@links = map { "edit_dbase.cgi?db=$_" } @titles;
	@titles = map { &html_escape($_) } @titles;
	print "<a href=newdb_form.cgi>$text{'index_add'}</a><br>\n"
		if ($access{'create'});
	&icons_table(\@links, \@titles, \@icons);
	print "<a href=newdb_form.cgi>$text{'index_add'}</a><p>\n"
		if ($access{'create'});

	if ($access{'users'}) {
		print "<hr>\n";
		print "<h3>$text{'index_users'}</h3>\n";
		@links = ( 'list_users.cgi', 'list_groups.cgi',
			   'list_hosts.cgi', 'list_grants.cgi' );
		@titles = ( $text{'user_title'}, $text{'group_title'},
			    $text{'host_title'}, $text{'grant_title'} );
		@images = ( 'images/users.gif', 'images/groups.gif',
			    'images/hosts.gif', 'images/grants.gif' );
		&icons_table(\@links, \@titles, \@images, 5);
		}

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=stop.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_stop'}\"></td>\n";
		print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}
	}

print "<hr>\n";
&footer("/", "index");

