#!/usr/local/bin/perl
# index.cgi
# Display a table of icons for cvs server options

require './pserver-lib.pl';
&ReadParse();

if (!$cvs_path) {
	&header($text{'index_title'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>",&text('index_ecvs', "<tt>$config{'cvs'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

$out = `$config{'cvs'} -v`;
if ($out !~ /CVS[^0-9\.]*([0-9\.]+)/) {
	&header($text{'index_title'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>",&text('index_eversion', "<tt>$config{'cvs'} -v</tt>",
			  "<pre>$out</pre>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$ver = $1;

&header($text{'index_title'}, "", undef, 1, 1, undef,
	&help_search_link("cvs", "man", "doc"), undef, undef,
	&text('index_version', $ver));
print "<hr>\n";

if (!-d "$config{'cvsroot'}/CVSROOT") {
	print "<p>",&text('index_eroot',
		"$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Show configuration icons
@icons = ( "images/passwd.gif", "images/access.gif", "images/config.gif",
           "images/cvsweb.gif" );
@links = ( "list_passwd.cgi", "edit_access.cgi", "edit_config.cgi",
	   "cvsweb.cgi" );
@titles = ( $text{'passwd_title'}, $text{'access_title'}, $text{'config_title'},
	    $text{'cvsweb_title'} );
&icons_table(\@links, \@titles, \@icons, 4);

# Check if run from inetd or xinetd
print "<hr>\n";
print "<table width=100%><tr>\n";
$inet = &check_inetd();
if (!$inet) {
	print "<form action=setup.cgi>\n";
	print "<td><input type=submit value='$text{'index_setup'}'></td>\n";
	print "<td>",&text('index_setupdesc',
		$has_xinetd ? "<tt>xinetd</tt>" : "<tt>inetd</tt>"),"</td>\n";
	print "</form>\n";
	}
elsif (!$inet->{'active'}) {
	print "<form action=setup.cgi>\n";
	print "<td><input type=submit value='$text{'index_act'}'></td>\n";
	print "<td>",&text('index_actdesc',
			   "<tt>$inet->{'type'}</tt>"),"</td>\n";
	print "</form>\n";
	}
else {
	print "<form action=setup.cgi>\n";
	print "<td><input type=submit value='$text{'index_deact'}'></td>\n";
	print "<td>",&text('index_deactdesc',
			   "<tt>$inet->{'type'}</tt>"),"</td>\n";
	print "</form>\n";
	}
print "</tr></table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

