# log_parser.pl
# Functions for parsing this module's logs

do 'qmail-lib.pl';

# parse_webmin_log(user, script, action, type, object, &params, long)
# Converts logged information from this module into human-readable form
sub parse_webmin_log
{
local ($user, $script, $action, $type, $object, $p, $long) = @_;
if ($type eq 'alias') {
	return &text("log_alias_$action",
		     "<tt>".&html_escape($object)."</tt>");
	}
elsif ($type eq 'virt') {
	return &text($object ne '-' ? "log_virt_$action" :
		"log_virtall_$action", "<tt>".&html_escape($object)."</tt>");
	}
elsif ($type eq 'route') {
	return &text("log_route_$action",
		     "<tt>".&html_escape($object)."</tt>");
	}
elsif ($type eq 'assign') {
	local $str = $object =~ /^=(\S*)/ ? $1 :
		     $object =~ /^\+(\S*)/ ? "$1*" : "";
	return &text("log_assign_$action", &html_escape($str));
	}
else {
	return $text{"log_$action"};
	}
}

