# generics-lib.pl
# Functions for the generics table

# generics_dbm(&config)
# Returns the filename and type of the generics database, or undef if none
sub generics_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^generics\s+(\S+)[^\/]+(\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# generics_file(&config)
# Returns the filename of the text generics file, or undef if none
sub generics_file
{
return &find_textfile($config{'generics_file'}, &generics_dbm($_[0]));
}

# list_generics(textfile)
sub list_generics
{
local($lnum, @rv);
$lnum = 0;
open(GEN, $_[0]);
while(<GEN>) {
	s/\r|\n//g;     # remove newlines
	s/#.*$//g;	# remove comments
	if (/^(\S+)\s+(.*)/) {
		local(%virt);
		$virt{'from'} = $1;
		$virt{'to'} = $2;
		$virt{'line'} = $lnum;
		$virt{'num'} = scalar(@rv);
		push(@rv, \%virt);
		}
	$lnum++;
	}
close(GEN);
return @rv;
}

# create_generic(&details, textfile, dbmfile, dbmtype)
# Create a new generic mapping
sub create_generic
{
local(%virt);
open(GEN, ">> $_[1]");
print GEN "$_[0]->{'from'}\t$_[0]->{'to'}\n";
close(GEN);
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	$virt{$_[0]->{'from'}} = $_[0]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# delete_generic(&details, textfile, dbmfile, dbmtype)
# Delete an existing generic mapping
sub delete_generic
{
local(@virt, %virt);
open(GEN, $_[1]);
@virt = <GEN>;
close(GEN);
splice(@virt, $_[0]->{'line'}, 1);
open(GEN, "> $_[1]");
print GEN @virt;
close(GEN);
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	delete($virt{$_[0]->{'from'}});
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# modify_generic(&old, &details, textfile, dbmfile, dbmtype)
# Change an existing generic
sub modify_generic
{
local(@virt, %virt);
open(GEN, $_[2]);
@virt = <GEN>;
close(GEN);
splice(@virt, $_[0]->{'line'}, 1, "$_[1]->{'from'}\t$_[1]->{'to'}\n");
open(GEN, "> $_[2]");
print GEN @virt;
close(GEN);
if ($_[4] eq "dbm") {
	dbmopen(%virt, $_[3], 0644);
	delete($virt{$_[0]->{'from'}});
	$virt{$_[1]->{'from'}} = $_[1]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }
}

sub generic_form([&details])
{
local $g = $_[0];
print "<form action=save_generic.cgi>\n";
if ($g) { print "<input type=hidden name=num value=$g->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$g ? $text{'gform_edit'} : $text{'gform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'gform_from'}</b></td>\n";
print "<td><input name=from size=30 value=\"$g->{'from'}\"></td> </tr>\n";
print "<tr> <td><b>$text{'gform_to'}</b></td>\n";
print "<td><input name=to size=30 value=\"$g->{'to'}\"></td> </tr>\n";

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value=\"$text{'save'}\">\n";
        print "<input type=submit name=delete value=\"$text{'delete'}\">\n";
        }
else { print "<input type=submit value=\"$text{'create'}\">\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

1;

